/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;

public class EdDSAPrivateKeySpec
implements KeySpec {
    private final byte[] seed;
    private final byte[] h;
    private final byte[] a;
    private final GroupElement A;
    private final EdDSAParameterSpec spec;

    public EdDSAPrivateKeySpec(byte[] seed, EdDSAParameterSpec spec) {
        if (seed.length != spec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("seed length is wrong");
        }
        this.spec = spec;
        this.seed = seed;
        try {
            MessageDigest hash = MessageDigest.getInstance(spec.getHashAlgorithm());
            int b2 = spec.getCurve().getField().getb();
            this.h = hash.digest(seed);
            this.h[0] = (byte)(this.h[0] & 0xF8);
            int n2 = b2 / 8 - 1;
            this.h[n2] = (byte)(this.h[n2] & 0x3F);
            int n3 = b2 / 8 - 1;
            this.h[n3] = (byte)(this.h[n3] | 0x40);
            this.a = Arrays.copyOfRange(this.h, 0, b2 / 8);
            this.A = spec.getB().scalarMultiply(this.a);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalArgumentException("Unsupported hash algorithm");
        }
    }

    public EdDSAPrivateKeySpec(EdDSAParameterSpec spec, byte[] h7) {
        if (h7.length != spec.getCurve().getField().getb() / 4) {
            throw new IllegalArgumentException("hash length is wrong");
        }
        this.seed = null;
        this.h = h7;
        this.spec = spec;
        int b2 = spec.getCurve().getField().getb();
        h7[0] = (byte)(h7[0] & 0xF8);
        int n2 = b2 / 8 - 1;
        h7[n2] = (byte)(h7[n2] & 0x3F);
        int n3 = b2 / 8 - 1;
        h7[n3] = (byte)(h7[n3] | 0x40);
        this.a = Arrays.copyOfRange(h7, 0, b2 / 8);
        this.A = spec.getB().scalarMultiply(this.a);
    }

    public EdDSAPrivateKeySpec(byte[] seed, byte[] h7, byte[] a2, GroupElement A2, EdDSAParameterSpec spec) {
        this.seed = seed;
        this.h = h7;
        this.a = a2;
        this.A = A2;
        this.spec = spec;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public byte[] getH() {
        return this.h;
    }

    public byte[] geta() {
        return this.a;
    }

    public GroupElement getA() {
        return this.A;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

