/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import com.hierynomus.sshj.key.KeyAlgorithm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.compression.Compression;
import net.schmizz.sshj.transport.kex.KeyExchange;
import net.schmizz.sshj.transport.mac.MAC;
import net.schmizz.sshj.transport.random.Random;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;

public class ConfigImpl
implements Config {
    private String version;
    private Factory<Random> randomFactory;
    private KeepAliveProvider keepAliveProvider;
    private List<Factory.Named<KeyExchange>> kexFactories;
    private List<Factory.Named<Cipher>> cipherFactories;
    private List<Factory.Named<Compression>> compressionFactories;
    private List<Factory.Named<MAC>> macFactories;
    private List<Factory.Named<KeyAlgorithm>> keyAlgorithms;
    private List<Factory.Named<FileKeyProvider>> fileKeyProviderFactories;
    private boolean waitForServerIdentBeforeSendingClientIdent = false;
    private LoggerFactory loggerFactory;
    private boolean verifyHostKeyCertificates = true;
    private int maxCircularBufferSize = 0x1000000;

    @Override
    public List<Factory.Named<Cipher>> getCipherFactories() {
        return this.cipherFactories;
    }

    @Override
    public List<Factory.Named<Compression>> getCompressionFactories() {
        return this.compressionFactories;
    }

    @Override
    public List<Factory.Named<FileKeyProvider>> getFileKeyProviderFactories() {
        return this.fileKeyProviderFactories;
    }

    @Override
    public List<Factory.Named<KeyExchange>> getKeyExchangeFactories() {
        return this.kexFactories;
    }

    @Override
    public List<Factory.Named<MAC>> getMACFactories() {
        return this.macFactories;
    }

    @Override
    public Factory<Random> getRandomFactory() {
        return this.randomFactory;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setCipherFactories(Factory.Named<Cipher> ... cipherFactories) {
        this.setCipherFactories(Arrays.asList(cipherFactories));
    }

    @Override
    public void setCipherFactories(List<Factory.Named<Cipher>> cipherFactories) {
        this.cipherFactories = cipherFactories;
    }

    public void setCompressionFactories(Factory.Named<Compression> ... compressionFactories) {
        this.setCompressionFactories(Arrays.asList(compressionFactories));
    }

    @Override
    public void setCompressionFactories(List<Factory.Named<Compression>> compressionFactories) {
        this.compressionFactories = compressionFactories;
    }

    public void setFileKeyProviderFactories(Factory.Named<FileKeyProvider> ... fileKeyProviderFactories) {
        this.setFileKeyProviderFactories(Arrays.asList(fileKeyProviderFactories));
    }

    @Override
    public void setFileKeyProviderFactories(List<Factory.Named<FileKeyProvider>> fileKeyProviderFactories) {
        this.fileKeyProviderFactories = fileKeyProviderFactories;
    }

    public void setKeyExchangeFactories(Factory.Named<KeyExchange> ... kexFactories) {
        this.setKeyExchangeFactories(Arrays.asList(kexFactories));
    }

    @Override
    public void setKeyExchangeFactories(List<Factory.Named<KeyExchange>> kexFactories) {
        this.kexFactories = kexFactories;
    }

    public void setMACFactories(Factory.Named<MAC> ... macFactories) {
        this.setMACFactories(Arrays.asList(macFactories));
    }

    @Override
    public void setMACFactories(List<Factory.Named<MAC>> macFactories) {
        this.macFactories = macFactories;
    }

    @Override
    public void setRandomFactory(Factory<Random> randomFactory) {
        this.randomFactory = randomFactory;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public KeepAliveProvider getKeepAliveProvider() {
        return this.keepAliveProvider;
    }

    @Override
    public void setKeepAliveProvider(KeepAliveProvider keepAliveProvider) {
        this.keepAliveProvider = keepAliveProvider;
    }

    @Override
    public boolean isWaitForServerIdentBeforeSendingClientIdent() {
        return this.waitForServerIdentBeforeSendingClientIdent;
    }

    @Override
    public void setWaitForServerIdentBeforeSendingClientIdent(boolean waitForServerIdentBeforeSendingClientIdent) {
        this.waitForServerIdentBeforeSendingClientIdent = waitForServerIdentBeforeSendingClientIdent;
    }

    @Override
    public List<Factory.Named<KeyAlgorithm>> getKeyAlgorithms() {
        return this.keyAlgorithms;
    }

    @Override
    public void setKeyAlgorithms(List<Factory.Named<KeyAlgorithm>> keyAlgorithms) {
        this.keyAlgorithms = keyAlgorithms;
    }

    @Override
    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public int getMaxCircularBufferSize() {
        return this.maxCircularBufferSize;
    }

    @Override
    public void setMaxCircularBufferSize(int maxCircularBufferSize) {
        this.maxCircularBufferSize = maxCircularBufferSize;
    }

    @Override
    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    @Override
    public boolean isVerifyHostKeyCertificates() {
        return this.verifyHostKeyCertificates;
    }

    @Override
    public void setVerifyHostKeyCertificates(boolean value) {
        this.verifyHostKeyCertificates = value;
    }

    public void prioritizeSshRsaKeyAlgorithm() {
        List<Factory.Named<KeyAlgorithm>> keyAlgorithms = this.getKeyAlgorithms();
        block0: for (int sshRsaIndex = 0; sshRsaIndex < keyAlgorithms.size(); ++sshRsaIndex) {
            if (!"ssh-rsa".equals(keyAlgorithms.get(sshRsaIndex).getName())) continue;
            for (int i2 = 0; i2 < sshRsaIndex; ++i2) {
                String algo = keyAlgorithms.get(i2).getName();
                if (!"rsa-sha2-256".equals(algo) && !"rsa-sha2-512".equals(algo)) continue;
                keyAlgorithms = new ArrayList<Factory.Named<KeyAlgorithm>>(keyAlgorithms);
                keyAlgorithms.add(i2, keyAlgorithms.remove(sshRsaIndex));
                this.setKeyAlgorithms(keyAlgorithms);
                break block0;
            }
            break;
        }
    }
}

