/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import net.schmizz.sshj.common.SSHException;

public class CircularBuffer<T extends CircularBuffer<T>> {
    private final int maxSize;
    private byte[] data;
    private int rpos;
    private int wpos;

    private int getNextSize(int currentSize) {
        int nextSize = 1;
        while (nextSize < currentSize) {
            if ((nextSize <<= 1) > 0) continue;
            return this.maxSize;
        }
        return Math.min(nextSize, this.maxSize);
    }

    public CircularBuffer(int size, int maxSize) {
        this.maxSize = maxSize;
        if (size > maxSize) {
            throw new IllegalArgumentException(String.format("Initial requested size %d larger than maximum size %d", size, maxSize));
        }
        int initialSize = this.getNextSize(size);
        this.data = new byte[initialSize];
        this.rpos = 0;
        this.wpos = 0;
    }

    public int available() {
        int available = this.wpos - this.rpos;
        return available >= 0 ? available : available + this.data.length;
    }

    private void ensureAvailable(int a2) throws CircularBufferException {
        if (this.available() < a2) {
            throw new CircularBufferException("Underflow");
        }
    }

    public int maxPossibleRemainingCapacity() {
        int remaining = this.rpos - this.wpos - 1;
        if (remaining < 0) {
            remaining += this.data.length;
        }
        return remaining + this.maxSize - this.data.length;
    }

    void ensureCapacity(int capacity) throws CircularBufferException {
        int available = this.available();
        int remaining = this.data.length - available;
        if (remaining <= capacity) {
            int neededSize = available + capacity + 1;
            int nextSize = this.getNextSize(neededSize);
            if (nextSize < neededSize) {
                throw new CircularBufferException("Attempted overflow");
            }
            byte[] tmp = new byte[nextSize];
            if (this.wpos >= this.rpos) {
                System.arraycopy(this.data, this.rpos, tmp, 0, available);
                this.wpos -= this.rpos;
            } else {
                int tail = this.data.length - this.rpos;
                System.arraycopy(this.data, this.rpos, tmp, 0, tail);
                System.arraycopy(this.data, 0, tmp, tail, this.wpos);
                this.wpos += tail;
            }
            this.rpos = 0;
            this.data = tmp;
        }
    }

    public void readRawBytes(byte[] destination, int offset, int length) throws CircularBufferException {
        this.ensureAvailable(length);
        int rposNext = this.rpos + length;
        if (rposNext <= this.data.length) {
            System.arraycopy(this.data, this.rpos, destination, offset, length);
        } else {
            int tail = this.data.length - this.rpos;
            System.arraycopy(this.data, this.rpos, destination, offset, tail);
            rposNext = length - tail;
            System.arraycopy(this.data, 0, destination, offset + tail, rposNext);
        }
        this.rpos = rposNext;
    }

    public T putRawBytes(byte[] source2, int offset, int length) throws CircularBufferException {
        this.ensureCapacity(length);
        int wposNext = this.wpos + length;
        if (wposNext <= this.data.length) {
            System.arraycopy(source2, offset, this.data, this.wpos, length);
        } else {
            int tail = this.data.length - this.wpos;
            System.arraycopy(source2, offset, this.data, this.wpos, tail);
            wposNext = length - tail;
            System.arraycopy(source2, offset + tail, this.data, 0, wposNext);
        }
        this.wpos = wposNext;
        return (T)this;
    }

    int length() {
        return this.data.length;
    }

    public String toString() {
        return "CircularBuffer [rpos=" + this.rpos + ", wpos=" + this.wpos + ", size=" + this.data.length + "]";
    }

    public static final class PlainCircularBuffer
    extends CircularBuffer<PlainCircularBuffer> {
        public PlainCircularBuffer(int size, int maxSize) {
            super(size, maxSize);
        }
    }

    public static class CircularBufferException
    extends SSHException {
        public CircularBufferException(String message) {
            super(message);
        }
    }
}

