/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

public enum Message {
    UNKNOWN(0),
    DISCONNECT(1),
    IGNORE(2),
    UNIMPLEMENTED(3),
    DEBUG(4),
    SERVICE_REQUEST(5),
    SERVICE_ACCEPT(6),
    EXT_INFO(7),
    KEXINIT(20),
    NEWKEYS(21),
    KEXDH_INIT(30),
    KEXDH_31(31),
    KEX_DH_GEX_INIT(32),
    KEX_DH_GEX_REPLY(33),
    KEX_DH_GEX_REQUEST(34),
    USERAUTH_REQUEST(50),
    USERAUTH_FAILURE(51),
    USERAUTH_SUCCESS(52),
    USERAUTH_BANNER(53),
    USERAUTH_60(60),
    USERAUTH_INFO_RESPONSE(61),
    USERAUTH_GSSAPI_EXCHANGE_COMPLETE(63),
    USERAUTH_GSSAPI_MIC(66),
    GLOBAL_REQUEST(80),
    REQUEST_SUCCESS(81),
    REQUEST_FAILURE(82),
    CHANNEL_OPEN(90),
    CHANNEL_OPEN_CONFIRMATION(91),
    CHANNEL_OPEN_FAILURE(92),
    CHANNEL_WINDOW_ADJUST(93),
    CHANNEL_DATA(94),
    CHANNEL_EXTENDED_DATA(95),
    CHANNEL_EOF(96),
    CHANNEL_CLOSE(97),
    CHANNEL_REQUEST(98),
    CHANNEL_SUCCESS(99),
    CHANNEL_FAILURE(100);

    private final byte b;
    private static final Message[] cache;

    public static Message fromByte(byte b2) {
        return cache[b2];
    }

    private Message(int b2) {
        this.b = (byte)b2;
    }

    public boolean geq(int num) {
        return this.b >= num;
    }

    public boolean gt(int num) {
        return this.b > num;
    }

    public boolean in(int x2, int y2) {
        return this.b >= x2 && this.b <= y2;
    }

    public boolean leq(int num) {
        return this.b <= num;
    }

    public boolean lt(int num) {
        return this.b < num;
    }

    public byte toByte() {
        return this.b;
    }

    static {
        cache = new Message[256];
        Message[] messageArray = Message.values();
        int n2 = messageArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Message c2;
            Message.cache[c2.toByte()] = c2 = messageArray[i2];
        }
        for (int i3 = 0; i3 < 256; ++i3) {
            if (cache[i3] != null) continue;
            Message.cache[i3] = UNKNOWN;
        }
    }
}

