/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ErrorNotifiable;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.AbstractChannel;
import net.schmizz.sshj.connection.channel.Window;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;

public final class ChannelOutputStream
extends OutputStream
implements ErrorNotifiable {
    private final AbstractChannel chan;
    private final Transport trans;
    private final Window.Remote win;
    private final DataBuffer buffer = new DataBuffer();
    private final byte[] b = new byte[1];
    private AtomicBoolean closed;
    private SSHException error;

    public ChannelOutputStream(AbstractChannel chan, Transport trans, Window.Remote win) {
        this.chan = chan;
        this.trans = trans;
        this.win = win;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public synchronized void write(int w2) throws IOException {
        this.b[0] = (byte)w2;
        this.write(this.b, 0, 1);
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        int n2;
        this.checkClose();
        int offset = off;
        for (int length = len; length > 0; length -= n2) {
            n2 = this.buffer.write(data, offset, length);
            offset += n2;
        }
    }

    @Override
    public synchronized void notifyError(SSHException error) {
        this.error = error;
    }

    private void checkClose() throws SSHException {
        if (this.closed.get() || !this.chan.isOpen()) {
            if (this.error != null) {
                throw this.error;
            }
            ChannelOutputStream.throwStreamClosed();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.chan.whileOpen(new AbstractChannel.TransportRunnable(){

                @Override
                public void run() throws TransportException, ConnectionException {
                    ChannelOutputStream.this.buffer.flush(false);
                    ChannelOutputStream.this.trans.write((SSHPacket)new SSHPacket(Message.CHANNEL_EOF).putUInt32(ChannelOutputStream.this.chan.getRecipient()));
                }
            });
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkClose();
        this.buffer.flush(true);
    }

    public String toString() {
        return "< ChannelOutputStream for Channel #" + this.chan.getID() + " >";
    }

    private static void throwStreamClosed() throws ConnectionException {
        throw new ConnectionException("Stream closed");
    }

    private final class DataBuffer {
        private final int headerOffset;
        private final int dataOffset;
        private final SSHPacket packet = new SSHPacket(Message.CHANNEL_DATA);
        private final Buffer.PlainBuffer leftOvers = new Buffer.PlainBuffer();
        private final AbstractChannel.TransportRunnable packetWriteRunnable = new AbstractChannel.TransportRunnable(){

            @Override
            public void run() throws TransportException {
                ChannelOutputStream.this.trans.write(DataBuffer.this.packet);
            }
        };

        DataBuffer() {
            this.headerOffset = this.packet.rpos();
            this.packet.putUInt32(0L);
            this.packet.putUInt32(0L);
            this.dataOffset = this.packet.wpos();
        }

        int write(byte[] data, int off, int len) throws TransportException, ConnectionException {
            int bufferSize = this.packet.wpos() - this.dataOffset;
            if (bufferSize >= ChannelOutputStream.this.win.getMaxPacketSize()) {
                this.flush(bufferSize, true);
                return 0;
            }
            int n2 = Math.min(len, ChannelOutputStream.this.win.getMaxPacketSize() - bufferSize);
            this.packet.putRawBytes(data, off, n2);
            return n2;
        }

        boolean flush(boolean canAwaitExpansion) throws TransportException, ConnectionException {
            return this.flush(this.packet.wpos() - this.dataOffset, canAwaitExpansion);
        }

        boolean flush(int bufferSize, boolean canAwaitExpansion) throws TransportException, ConnectionException {
            int dataLeft = bufferSize;
            while (dataLeft > 0) {
                long remoteWindowSize = ChannelOutputStream.this.win.getSize();
                if (remoteWindowSize == 0L) {
                    if (canAwaitExpansion) {
                        remoteWindowSize = ChannelOutputStream.this.win.awaitExpansion(remoteWindowSize);
                    } else {
                        return false;
                    }
                }
                int writeNow = Math.min(dataLeft, (int)Math.min((long)ChannelOutputStream.this.win.getMaxPacketSize(), remoteWindowSize));
                this.packet.wpos(this.headerOffset);
                this.packet.putMessageID(Message.CHANNEL_DATA);
                this.packet.putUInt32FromInt(ChannelOutputStream.this.chan.getRecipient());
                this.packet.putUInt32(writeNow);
                this.packet.wpos(this.dataOffset + writeNow);
                int leftOverBytes = dataLeft - writeNow;
                if (leftOverBytes > 0) {
                    this.leftOvers.putRawBytes(this.packet.array(), this.packet.wpos(), leftOverBytes);
                }
                if (!ChannelOutputStream.this.chan.whileOpen(this.packetWriteRunnable)) {
                    ChannelOutputStream.throwStreamClosed();
                }
                ChannelOutputStream.this.win.consume(writeNow);
                this.packet.rpos(this.headerOffset);
                this.packet.wpos(this.dataOffset);
                if (leftOverBytes > 0) {
                    this.packet.putBuffer(this.leftOvers);
                    this.leftOvers.clear();
                }
                dataLeft = leftOverBytes;
            }
            return true;
        }
    }
}

