/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

public enum PacketType {
    UNKNOWN(0),
    INIT(1),
    VERSION(2),
    OPEN(3),
    CLOSE(4),
    READ(5),
    WRITE(6),
    LSTAT(7),
    FSTAT(8),
    SETSTAT(9),
    FSETSTAT(10),
    OPENDIR(11),
    READDIR(12),
    REMOVE(13),
    MKDIR(14),
    RMDIR(15),
    REALPATH(16),
    STAT(17),
    RENAME(18),
    READLINK(19),
    SYMLINK(20),
    STATUS(101),
    HANDLE(102),
    DATA(103),
    NAME(104),
    ATTRS(105),
    EXTENDED(200),
    EXTENDED_REPLY(201);

    private final byte b;
    private static final PacketType[] cache;

    private PacketType(int b2) {
        this.b = (byte)b2;
    }

    public static PacketType fromByte(byte b2) {
        return cache[b2 & 0xFF];
    }

    public byte toByte() {
        return this.b;
    }

    static {
        cache = new PacketType[256];
        PacketType[] packetTypeArray = PacketType.values();
        int n2 = packetTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PacketType t2;
            PacketType.cache[t2.toByte() & 0xFF] = t2 = packetTypeArray[i2];
        }
    }
}

