/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Arrays;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignatureDSA;
import net.schmizz.sshj.signature.Signature;

public class SignatureDSA
extends AbstractSignatureDSA {
    public SignatureDSA() {
        super("SHA1withDSA", KeyType.DSA.toString());
    }

    @Override
    public byte[] encode(byte[] sig) {
        int rIndex = 3;
        int rLen = sig[rIndex++] & 0xFF;
        byte[] r2 = new byte[rLen];
        System.arraycopy(sig, rIndex, r2, 0, r2.length);
        int sIndex = rIndex + rLen + 1;
        int sLen = sig[sIndex++] & 0xFF;
        byte[] s2 = new byte[sLen];
        System.arraycopy(sig, sIndex, s2, 0, s2.length);
        byte[] result2 = new byte[40];
        int r_copylen = Math.min(r2.length, 20);
        int s_copylen = Math.min(s2.length, 20);
        System.arraycopy(r2, r2.length - r_copylen, result2, 20 - r_copylen, r_copylen);
        System.arraycopy(s2, s2.length - s_copylen, result2, 40 - s_copylen, s_copylen);
        return result2;
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            byte[] sigBlob = this.extractSig(sig, "ssh-dss");
            BigInteger r2 = new BigInteger(1, Arrays.copyOfRange(sigBlob, 0, 20));
            BigInteger s2 = new BigInteger(1, Arrays.copyOfRange(sigBlob, 20, 40));
            return this.signature.verify(this.encodeAsnSignature(r2, s2));
        }
        catch (SignatureException e2) {
            throw new SSHRuntimeException(e2);
        }
        catch (IOException e3) {
            throw new SSHRuntimeException(e3);
        }
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureDSA();
        }

        @Override
        public String getName() {
            return KeyType.DSA.toString();
        }
    }
}

