/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.NegotiatedAlgorithms;
import net.schmizz.sshj.transport.TransportException;

class Proposal {
    private final List<String> kex;
    private final List<String> sig;
    private final List<String> c2sCipher;
    private final List<String> s2cCipher;
    private final List<String> c2sMAC;
    private final List<String> s2cMAC;
    private final List<String> c2sComp;
    private final List<String> s2cComp;
    private final SSHPacket packet;

    public Proposal(Config config, List<String> knownHostAlgs, boolean initialKex) {
        this.kex = Factory.Named.Util.getNames(config.getKeyExchangeFactories());
        if (initialKex) {
            this.kex.add("kex-strict-c-v00@openssh.com");
        }
        this.sig = this.filterKnownHostKeyAlgorithms(Factory.Named.Util.getNames(config.getKeyAlgorithms()), knownHostAlgs);
        this.s2cCipher = Factory.Named.Util.getNames(config.getCipherFactories());
        this.c2sCipher = this.s2cCipher;
        this.s2cMAC = Factory.Named.Util.getNames(config.getMACFactories());
        this.c2sMAC = this.s2cMAC;
        this.s2cComp = Factory.Named.Util.getNames(config.getCompressionFactories());
        this.c2sComp = this.s2cComp;
        this.packet = new SSHPacket(Message.KEXINIT);
        this.packet.ensureCapacity(16);
        config.getRandomFactory().create().fill(this.packet.array(), this.packet.wpos(), 16);
        this.packet.wpos(this.packet.wpos() + 16);
        this.packet.putString(Proposal.toCommaString(this.kex));
        this.packet.putString(Proposal.toCommaString(this.sig));
        this.packet.putString(Proposal.toCommaString(this.c2sCipher));
        this.packet.putString(Proposal.toCommaString(this.s2cCipher));
        this.packet.putString(Proposal.toCommaString(this.c2sMAC));
        this.packet.putString(Proposal.toCommaString(this.s2cMAC));
        this.packet.putString(Proposal.toCommaString(this.c2sComp));
        this.packet.putString(Proposal.toCommaString(this.s2cComp));
        this.packet.putString("");
        this.packet.putString("");
        this.packet.putBoolean(false);
        this.packet.putUInt32(0L);
    }

    public Proposal(SSHPacket packet) throws TransportException {
        this.packet = packet;
        int savedPos = packet.rpos();
        packet.rpos(packet.rpos() + 17);
        try {
            this.kex = Proposal.fromCommaString(packet.readString());
            this.sig = Proposal.fromCommaString(packet.readString());
            this.c2sCipher = Proposal.fromCommaString(packet.readString());
            this.s2cCipher = Proposal.fromCommaString(packet.readString());
            this.c2sMAC = Proposal.fromCommaString(packet.readString());
            this.s2cMAC = Proposal.fromCommaString(packet.readString());
            this.c2sComp = Proposal.fromCommaString(packet.readString());
            this.s2cComp = Proposal.fromCommaString(packet.readString());
        }
        catch (Buffer.BufferException be2) {
            throw new TransportException(be2);
        }
        packet.rpos(savedPos);
    }

    public List<String> getKeyExchangeAlgorithms() {
        return this.kex;
    }

    public boolean isStrictKeyExchangeSupportedByServer() {
        return this.kex.contains("kex-strict-s-v00@openssh.com");
    }

    public List<String> getHostKeyAlgorithms() {
        return this.sig;
    }

    public List<String> getClient2ServerCipherAlgorithms() {
        return this.c2sCipher;
    }

    public List<String> getServer2ClientCipherAlgorithms() {
        return this.s2cCipher;
    }

    public List<String> getClient2ServerMACAlgorithms() {
        return this.c2sMAC;
    }

    public List<String> getServer2ClientMACAlgorithms() {
        return this.s2cMAC;
    }

    public List<String> getClient2ServerCompressionAlgorithms() {
        return this.c2sComp;
    }

    public List<String> getServer2ClientCompressionAlgorithms() {
        return this.s2cComp;
    }

    public SSHPacket getPacket() {
        return new SSHPacket(this.packet);
    }

    public NegotiatedAlgorithms negotiate(Proposal other) throws TransportException {
        return new NegotiatedAlgorithms(Proposal.firstMatch("KeyExchangeAlgorithms", this.getKeyExchangeAlgorithms(), other.getKeyExchangeAlgorithms()), Proposal.firstMatch("HostKeyAlgorithms", this.getHostKeyAlgorithms(), other.getHostKeyAlgorithms()), Proposal.firstMatch("Client2ServerCipherAlgorithms", this.getClient2ServerCipherAlgorithms(), other.getClient2ServerCipherAlgorithms()), Proposal.firstMatch("Server2ClientCipherAlgorithms", this.getServer2ClientCipherAlgorithms(), other.getServer2ClientCipherAlgorithms()), Proposal.firstMatch("Client2ServerMACAlgorithms", this.getClient2ServerMACAlgorithms(), other.getClient2ServerMACAlgorithms()), Proposal.firstMatch("Server2ClientMACAlgorithms", this.getServer2ClientMACAlgorithms(), other.getServer2ClientMACAlgorithms()), Proposal.firstMatch("Client2ServerCompressionAlgorithms", this.getClient2ServerCompressionAlgorithms(), other.getClient2ServerCompressionAlgorithms()), Proposal.firstMatch("Server2ClientCompressionAlgorithms", this.getServer2ClientCompressionAlgorithms(), other.getServer2ClientCompressionAlgorithms()));
    }

    private List<String> filterKnownHostKeyAlgorithms(List<String> configuredKeyAlgorithms, List<String> knownHostKeyAlgorithms) {
        if (knownHostKeyAlgorithms != null && !knownHostKeyAlgorithms.isEmpty()) {
            ArrayList<String> preferredAlgorithms = new ArrayList<String>();
            ArrayList<String> otherAlgorithms = new ArrayList<String>();
            for (String configuredKeyAlgorithm : configuredKeyAlgorithms) {
                if (knownHostKeyAlgorithms.contains(configuredKeyAlgorithm)) {
                    preferredAlgorithms.add(configuredKeyAlgorithm);
                    continue;
                }
                otherAlgorithms.add(configuredKeyAlgorithm);
            }
            preferredAlgorithms.addAll(otherAlgorithms);
            return preferredAlgorithms;
        }
        return configuredKeyAlgorithms;
    }

    private static String firstMatch(String ofWhat, List<String> a2, List<String> b2) throws TransportException {
        for (String aa2 : a2) {
            if (!b2.contains(aa2)) continue;
            return aa2;
        }
        throw new TransportException("Unable to reach a settlement of " + ofWhat + ": " + a2 + " and " + b2);
    }

    private static String toCommaString(List<String> sl) {
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        for (String s2 : sl) {
            if (i2++ != 0) {
                sb.append(",");
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    private static List<String> fromCommaString(String s2) {
        return Arrays.asList(s2.split(","));
    }
}

