/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.cipher.Cipher;

public abstract class BaseCipher
implements Cipher {
    private final int ivsize;
    private final int bsize;
    private final String algorithm;
    private final String transformation;
    protected javax.crypto.Cipher cipher;

    private static byte[] resize(byte[] data, int size) {
        if (data.length > size) {
            byte[] tmp = new byte[size];
            System.arraycopy(data, 0, tmp, 0, size);
            data = tmp;
        }
        return data;
    }

    public BaseCipher(int ivsize, int bsize, String algorithm, String transformation) {
        this.ivsize = ivsize;
        this.bsize = bsize;
        this.algorithm = algorithm;
        this.transformation = transformation;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return 0;
    }

    @Override
    public void init(Cipher.Mode mode, byte[] key, byte[] iv) {
        key = BaseCipher.resize(key, this.bsize);
        iv = BaseCipher.resize(iv, this.ivsize);
        try {
            this.cipher = SecurityUtils.getCipher(this.transformation);
            this.initCipher(this.cipher, mode, key, iv);
        }
        catch (GeneralSecurityException e2) {
            this.cipher = null;
            throw new SSHRuntimeException(e2);
        }
    }

    protected abstract void initCipher(javax.crypto.Cipher var1, Cipher.Mode var2, byte[] var3, byte[] var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected SecretKeySpec getKeySpec(byte[] key) {
        return new SecretKeySpec(key, this.algorithm);
    }

    protected int getMode(Cipher.Mode mode) {
        return mode == Cipher.Mode.Encrypt ? 1 : 2;
    }

    @Override
    public void update(byte[] input2, int inputOffset, int inputLen) {
        try {
            this.cipher.update(input2, inputOffset, inputLen, input2, inputOffset);
        }
        catch (ShortBufferException e2) {
            throw new SSHRuntimeException(e2);
        }
    }

    @Override
    public void updateAAD(byte[] data, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass() + " does not support AAD operations");
    }

    @Override
    public void updateAAD(byte[] data) {
        this.updateAAD(data, 0, data.length);
    }

    @Override
    public void updateWithAAD(byte[] input2, int offset, int aadLen, int inputLen) {
        this.updateAAD(input2, offset, aadLen);
        this.update(input2, offset + aadLen, inputLen);
    }

    @Override
    public void setSequenceNumber(long seq) {
    }
}

