/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.random;

import java.security.SecureRandom;
import net.schmizz.sshj.transport.random.Random;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleRandom
implements Random {
    private static final Logger logger = LoggerFactory.getLogger(BouncyCastleRandom.class);
    private final RandomGenerator random = new VMPCRandomGenerator();

    public BouncyCastleRandom() {
        logger.info("Generating random seed from SecureRandom.");
        long t2 = System.currentTimeMillis();
        byte[] seed = new SecureRandom().generateSeed(8);
        logger.debug("Creating random seed took {} ms", (Object)(System.currentTimeMillis() - t2));
        this.random.addSeedMaterial(seed);
    }

    @Override
    public void fill(byte[] bytes, int start, int len) {
        this.random.nextBytes(bytes, start, len);
    }

    @Override
    public void fill(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public static class Factory
    implements net.schmizz.sshj.common.Factory<Random> {
        @Override
        public Random create() {
            return new BouncyCastleRandom();
        }
    }
}

