/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.random;

import java.security.SecureRandom;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.random.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCERandom
implements Random {
    private static final Logger logger = LoggerFactory.getLogger(JCERandom.class);
    private byte[] tmp = new byte[16];
    private final SecureRandom random;

    JCERandom() {
        logger.info("Creating new SecureRandom.");
        long t2 = System.currentTimeMillis();
        this.random = new SecureRandom();
        logger.debug("Random creation took {} ms", (Object)(System.currentTimeMillis() - t2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void fill(byte[] foo, int start, int len) {
        if (start == 0 && len == foo.length) {
            this.random.nextBytes(foo);
        } else {
            JCERandom jCERandom = this;
            synchronized (jCERandom) {
                if (len > this.tmp.length) {
                    this.tmp = new byte[len];
                }
                this.random.nextBytes(this.tmp);
                System.arraycopy(this.tmp, 0, foo, start, len);
            }
        }
    }

    @Override
    public void fill(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public static class Factory
    implements Factory.Named<Random> {
        @Override
        public Random create() {
            return new JCERandom();
        }

        @Override
        public String getName() {
            return "default";
        }
    }
}

