/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;

public class KeyProviderUtil {
    public static KeyFormat detectKeyFileFormat(File location) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new FileReader(location), new File(location + ".pub").exists() || new File(location + "-cert.pub").exists());
    }

    public static KeyFormat detectKeyFileFormat(String privateKey, boolean separatePubKey) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new StringReader(privateKey), separatePubKey);
    }

    public static KeyFormat detectKeyFileFormat(Reader privateKey, boolean separatePubKey) throws IOException {
        String header2 = KeyProviderUtil.readHeader(privateKey);
        if (header2 == null) {
            throw new IOException("Empty file");
        }
        return KeyProviderUtil.keyFormatFromHeader(header2, separatePubKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readHeader(Reader privateKey) throws IOException {
        String string2;
        BufferedReader br2 = new BufferedReader(privateKey);
        try {
            String header2;
            while ((header2 = br2.readLine()) != null && (header2 = header2.trim()).isEmpty()) {
            }
            string2 = header2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br2);
            throw throwable;
        }
        IOUtils.closeQuietly(br2);
        return string2;
    }

    private static KeyFormat keyFormatFromHeader(String header2, boolean separatePubKey) {
        if (header2.startsWith("-----BEGIN") && header2.endsWith("PRIVATE KEY-----")) {
            if (header2.contains("OPENSSH PRIVATE KEY-----")) {
                return KeyFormat.OpenSSHv1;
            }
            if (separatePubKey) {
                return KeyFormat.OpenSSH;
            }
            return KeyFormat.PKCS8;
        }
        if (header2.startsWith("PuTTY-User-Key-File-")) {
            return KeyFormat.PuTTY;
        }
        return KeyFormat.Unknown;
    }
}

