/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import one.util.streamex.Internals;

final class CollapseSpliterator<T, R>
extends Internals.Box<T>
implements Spliterator<R> {
    private final Spliterator<T> source;
    private final CollapseSpliterator<T, R> root;
    private R acc;
    volatile Connector<T, R> left;
    volatile Connector<T, R> right;
    private final Function<T, R> mapper;
    private final BiFunction<R, T, R> accumulator;
    private final BinaryOperator<R> combiner;
    private final BiPredicate<? super T, ? super T> mergeable;

    CollapseSpliterator(BiPredicate<? super T, ? super T> mergeable, Function<T, R> mapper, BiFunction<R, T, R> accumulator, BinaryOperator<R> combiner, Spliterator<T> source2) {
        super(Internals.none());
        this.source = source2;
        this.mergeable = mergeable;
        this.mapper = mapper;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.root = this;
    }

    private CollapseSpliterator(CollapseSpliterator<T, R> root, Spliterator<T> source2, Connector<T, R> left, Connector<T, R> right) {
        super(Internals.none());
        this.source = source2;
        this.root = root;
        this.mergeable = root.mergeable;
        this.mapper = root.mapper;
        this.accumulator = root.accumulator;
        this.combiner = root.combiner;
        this.left = left;
        this.right = right;
        if (left != null) {
            left.rhs = this;
        }
        right.lhs = this;
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        if (this.left != null && this.accept(this.handleLeft(), action)) {
            return true;
        }
        if (this.a == Internals.NONE && !this.source.tryAdvance(this)) {
            return this.accept(this.pushRight(Internals.none(), Internals.none()), action);
        }
        Object first2 = this.a;
        R acc = this.mapper.apply(this.a);
        Object last = first2;
        while (this.source.tryAdvance(this)) {
            if (!this.mergeable.test(last, this.a)) {
                action.accept(acc);
                return true;
            }
            last = this.a;
            acc = this.accumulator.apply(acc, last);
        }
        return this.accept(this.pushRight(acc, last), action);
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        while (this.left != null) {
            this.accept(this.handleLeft(), action);
        }
        if (this.a != Internals.NONE) {
            this.acc = this.mapper.apply(this.a);
        }
        this.source.forEachRemaining((? super T next2) -> {
            if (this.a == Internals.NONE) {
                this.acc = this.mapper.apply(next2);
            } else if (!this.mergeable.test(this.a, next2)) {
                action.accept(this.acc);
                this.acc = this.mapper.apply(next2);
            } else {
                this.acc = this.accumulator.apply(this.acc, next2);
            }
            this.a = next2;
        });
        if (this.a == Internals.NONE) {
            this.accept(this.pushRight(Internals.none(), Internals.none()), action);
        } else if (this.accept(this.pushRight(this.acc, this.a), action) && this.right != null) {
            action.accept(this.right.acc);
            this.right = null;
        }
    }

    private boolean accept(R acc, Consumer<? super R> action) {
        if (acc != Internals.NONE) {
            action.accept(acc);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R handleLeft() {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l2 = this.left;
            if (l2 == null) {
                return (R)Internals.none();
            }
            if (l2.left == Internals.NONE && l2.right == Internals.NONE && l2.acc != Internals.NONE) {
                return l2.drain();
            }
        }
        if (this.source.tryAdvance(this)) {
            Object first2;
            Object last = first2 = this.a;
            R acc = this.mapper.apply(first2);
            while (this.source.tryAdvance(this)) {
                if (!this.mergeable.test(last, this.a)) {
                    return this.pushLeft(first2, acc);
                }
                last = this.a;
                acc = this.accumulator.apply(acc, last);
            }
            this.a = Internals.none();
            return this.connectOne(first2, acc, last);
        }
        return this.connectEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R pushLeft(T first2, R acc) {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l2 = this.left;
            if (l2 == null) {
                return acc;
            }
            this.left = null;
            l2.rhs = null;
            Object laright = l2.right;
            l2.right = Internals.none();
            if (l2.acc == Internals.NONE) {
                l2.acc = acc;
                l2.left = first2;
                return (R)Internals.none();
            }
            if (this.mergeable.test(laright, first2)) {
                l2.acc = this.combiner.apply(l2.acc, acc);
                return l2.drainLeft();
            }
            if (l2.left == Internals.NONE) {
                this.left = new Connector(null, acc, this);
                return l2.drain();
            }
        }
        return acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R pushRight(R acc, T last) {
        this.a = Internals.none();
        if (this.right == null) {
            return acc;
        }
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> r2 = this.right;
            if (r2 == null) {
                return acc;
            }
            this.right = null;
            r2.lhs = null;
            Object raleft = r2.left;
            r2.left = Internals.none();
            if (r2.acc == Internals.NONE) {
                if (acc == Internals.NONE) {
                    r2.drain();
                } else {
                    r2.acc = acc;
                    r2.right = last;
                }
                return (R)Internals.none();
            }
            if (acc == Internals.NONE) {
                return r2.drainRight();
            }
            if (this.mergeable.test(last, raleft)) {
                r2.acc = this.combiner.apply(acc, r2.acc);
                return r2.drainRight();
            }
            if (r2.right == Internals.NONE) {
                this.right = new Connector(this, r2.drain(), null);
            }
            return acc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R connectOne(T first2, R acc, T last) {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l2 = this.left;
            if (l2 == null) {
                return this.pushRight(acc, last);
            }
            if (l2.acc == Internals.NONE) {
                l2.acc = acc;
                l2.left = first2;
                l2.right = last;
                return this.connectEmpty();
            }
            Object laright = l2.right;
            if (this.mergeable.test(laright, first2)) {
                l2.acc = this.combiner.apply(l2.acc, acc);
                l2.right = last;
                return this.connectEmpty();
            }
            this.left = null;
            l2.rhs = null;
            l2.right = Internals.none();
            if (l2.left != Internals.NONE) {
                return this.pushRight(acc, last);
            }
            if ((acc = this.pushRight(acc, last)) != Internals.NONE) {
                this.left = new Connector(null, acc, this);
            }
            return l2.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R connectEmpty() {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l2 = this.left;
            Connector<T, R> r2 = this.right;
            if (l2 == null) {
                return (R)this.pushRight(Internals.none(), Internals.none());
            }
            this.right = null;
            this.left = null;
            l2.rhs = null;
            Object laright = l2.right;
            l2.right = Internals.none();
            if (l2.acc == Internals.NONE) {
                if (r2 == null) {
                    l2.drain();
                } else if (l2.lhs != null) {
                    l2.lhs.right = r2;
                    r2.lhs = l2.lhs;
                }
                return (R)Internals.none();
            }
            if (r2 == null) {
                return l2.drainLeft();
            }
            r2.lhs = null;
            if (r2.acc == Internals.NONE) {
                if (r2.rhs != null) {
                    r2.rhs.left = l2;
                    l2.rhs = r2.rhs;
                    l2.right = laright;
                }
                return (R)Internals.none();
            }
            Object raleft = r2.left;
            r2.left = Internals.none();
            if (this.mergeable.test(laright, raleft)) {
                Object acc = this.combiner.apply(l2.acc, r2.acc);
                if (l2.left == Internals.NONE && r2.right == Internals.NONE) {
                    l2.drain();
                    r2.drain();
                    return acc;
                }
                l2.acc = acc;
                l2.right = r2.right;
                if (r2.rhs != null) {
                    r2.rhs.left = l2;
                    l2.rhs = r2.rhs;
                }
                return (R)Internals.none();
            }
            if (l2.left == Internals.NONE) {
                if (r2.right == Internals.NONE) {
                    this.right = new Connector(this, r2.drain(), null);
                }
                return l2.drain();
            }
            return r2.drainRight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<R> trySplit() {
        Spliterator<T> prefix = this.source.trySplit();
        if (prefix == null) {
            return null;
        }
        Connector newBox = new Connector(null, Internals.none(), this);
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            CollapseSpliterator<T, R> result2 = new CollapseSpliterator<T, R>(this.root, prefix, this.left, newBox);
            this.left = newBox;
            return result2;
        }
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0x1410;
    }

    private static final class Connector<T, R> {
        CollapseSpliterator<T, R> lhs;
        CollapseSpliterator<T, R> rhs;
        T left = Internals.none();
        T right = Internals.none();
        R acc;

        Connector(CollapseSpliterator<T, R> lhs, R acc, CollapseSpliterator<T, R> rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.acc = acc;
        }

        R drain() {
            if (this.lhs != null) {
                this.lhs.right = null;
            }
            if (this.rhs != null) {
                this.rhs.left = null;
            }
            return this.acc;
        }

        R drainLeft() {
            return (R)(this.left == Internals.NONE ? this.drain() : Internals.none());
        }

        R drainRight() {
            return (R)(this.right == Internals.NONE ? this.drain() : Internals.none());
        }
    }
}

