/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args;
    private final List<Option> options;
    private final transient Consumer<Option> deprecatedHandler;

    public static Builder builder() {
        return new Builder();
    }

    protected CommandLine() {
        this(new LinkedList<String>(), new ArrayList<Option>(), Builder.DEPRECATED_HANDLER);
    }

    private CommandLine(List<String> args, List<Option> options, Consumer<Option> deprecatedHandler) {
        this.args = Objects.requireNonNull(args, "args");
        this.options = Objects.requireNonNull(options, "options");
        this.deprecatedHandler = deprecatedHandler;
    }

    protected void addArg(String arg) {
        if (arg != null) {
            this.args.add(arg);
        }
    }

    protected void addOption(Option option2) {
        if (option2 != null) {
            this.options.add(option2);
        }
    }

    private <T> T get(Supplier<T> supplier) {
        return supplier == null ? null : (T)supplier.get();
    }

    public List<String> getArgList() {
        return this.args;
    }

    public String[] getArgs() {
        return this.args.toArray(Util.EMPTY_STRING_ARRAY);
    }

    @Deprecated
    public Object getOptionObject(char optionChar) {
        return this.getOptionObject(String.valueOf(optionChar));
    }

    @Deprecated
    public Object getOptionObject(String optionName) {
        try {
            return this.getParsedOptionValue(optionName);
        }
        catch (ParseException pe) {
            System.err.println("Exception found converting " + optionName + " to desired type: " + pe.getMessage());
            return null;
        }
    }

    public Properties getOptionProperties(Option option2) {
        Properties props = new Properties();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option2)) continue;
            this.processPropertiesFromValues(props, processedOption.getValuesList());
        }
        return props;
    }

    public Properties getOptionProperties(String optionName) {
        Properties props = new Properties();
        for (Option option2 : this.options) {
            if (!optionName.equals(option2.getOpt()) && !optionName.equals(option2.getLongOpt())) continue;
            this.processPropertiesFromValues(props, option2.getValuesList());
        }
        return props;
    }

    public Option[] getOptions() {
        return this.options.toArray(Option.EMPTY_ARRAY);
    }

    public String getOptionValue(char optionChar) {
        return this.getOptionValue(String.valueOf(optionChar));
    }

    public String getOptionValue(char optionChar, String defaultValue) {
        return this.getOptionValue(String.valueOf(optionChar), () -> defaultValue);
    }

    public String getOptionValue(char optionChar, Supplier<String> defaultValue) {
        return this.getOptionValue(String.valueOf(optionChar), defaultValue);
    }

    public String getOptionValue(Option option2) {
        String[] values = this.getOptionValues(option2);
        return values == null ? null : values[0];
    }

    public String getOptionValue(Option option2, String defaultValue) {
        return this.getOptionValue(option2, () -> defaultValue);
    }

    public String getOptionValue(Option option2, Supplier<String> defaultValue) {
        String answer = this.getOptionValue(option2);
        return answer != null ? answer : this.get(defaultValue);
    }

    public String getOptionValue(OptionGroup optionGroup) {
        String[] values = this.getOptionValues(optionGroup);
        return values == null ? null : values[0];
    }

    public String getOptionValue(OptionGroup optionGroup, String defaultValue) {
        return this.getOptionValue(optionGroup, () -> defaultValue);
    }

    public String getOptionValue(OptionGroup optionGroup, Supplier<String> defaultValue) {
        String answer = this.getOptionValue(optionGroup);
        return answer != null ? answer : this.get(defaultValue);
    }

    public String getOptionValue(String optionName) {
        return this.getOptionValue(this.resolveOption(optionName));
    }

    public String getOptionValue(String optionName, String defaultValue) {
        return this.getOptionValue(this.resolveOption(optionName), () -> defaultValue);
    }

    public String getOptionValue(String optionName, Supplier<String> defaultValue) {
        return this.getOptionValue(this.resolveOption(optionName), defaultValue);
    }

    public String[] getOptionValues(char optionChar) {
        return this.getOptionValues(String.valueOf(optionChar));
    }

    public String[] getOptionValues(Option option2) {
        if (option2 == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option2)) continue;
            if (option2.isDeprecated()) {
                this.handleDeprecated(option2);
            }
            values.addAll(processedOption.getValuesList());
        }
        return values.isEmpty() ? null : values.toArray(Util.EMPTY_STRING_ARRAY);
    }

    public String[] getOptionValues(OptionGroup optionGroup) {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return null;
        }
        return this.getOptionValues(optionGroup.getSelected());
    }

    public String[] getOptionValues(String optionName) {
        return this.getOptionValues(this.resolveOption(optionName));
    }

    public <T> T getParsedOptionValue(char optionChar) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(optionChar));
    }

    public <T> T getParsedOptionValue(char optionChar, Supplier<T> defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(String.valueOf(optionChar), (T)defaultValue);
    }

    public <T> T getParsedOptionValue(char optionChar, T defaultValue) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(optionChar), defaultValue);
    }

    public <T> T getParsedOptionValue(Option option2) throws ParseException {
        return (T)this.getParsedOptionValue(option2, (T)((Supplier<Object>)() -> null));
    }

    public <T> T getParsedOptionValue(Option option2, Supplier<T> defaultValue) throws ParseException {
        if (option2 == null) {
            return this.get(defaultValue);
        }
        String res2 = this.getOptionValue(option2);
        try {
            if (res2 == null) {
                return this.get(defaultValue);
            }
            return (T)option2.getConverter().apply(res2);
        }
        catch (Exception e2) {
            throw ParseException.wrap(e2);
        }
    }

    public <T> T getParsedOptionValue(Option option2, T defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(option2, (T)((Supplier<Object>)() -> defaultValue));
    }

    public <T> T getParsedOptionValue(OptionGroup optionGroup) throws ParseException {
        return (T)this.getParsedOptionValue(optionGroup, (T)((Supplier<Object>)() -> null));
    }

    public <T> T getParsedOptionValue(OptionGroup optionGroup, Supplier<T> defaultValue) throws ParseException {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return this.get(defaultValue);
        }
        return (T)this.getParsedOptionValue(optionGroup.getSelected(), (T)defaultValue);
    }

    public <T> T getParsedOptionValue(OptionGroup optionGroup, T defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(optionGroup, (T)((Supplier<Object>)() -> defaultValue));
    }

    public <T> T getParsedOptionValue(String optionName) throws ParseException {
        return this.getParsedOptionValue(this.resolveOption(optionName));
    }

    public <T> T getParsedOptionValue(String optionName, Supplier<T> defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(this.resolveOption(optionName), (T)defaultValue);
    }

    public <T> T getParsedOptionValue(String optionName, T defaultValue) throws ParseException {
        return this.getParsedOptionValue(this.resolveOption(optionName), defaultValue);
    }

    public <T> T[] getParsedOptionValues(char optionChar) throws ParseException {
        return this.getParsedOptionValues(String.valueOf(optionChar));
    }

    public <T> T[] getParsedOptionValues(char optionChar, Supplier<T[]> defaultValue) throws ParseException {
        return this.getParsedOptionValues(String.valueOf(optionChar), defaultValue);
    }

    public <T> T[] getParsedOptionValues(char optionChar, T[] defaultValue) throws ParseException {
        return this.getParsedOptionValues(String.valueOf(optionChar), defaultValue);
    }

    public <T> T[] getParsedOptionValues(Option option2) throws ParseException {
        return this.getParsedOptionValues(option2, () -> null);
    }

    public <T> T[] getParsedOptionValues(Option option2, Supplier<T[]> defaultValue) throws ParseException {
        if (option2 == null) {
            return this.get(defaultValue);
        }
        Class clazz = (Class)option2.getType();
        String[] values = this.getOptionValues(option2);
        if (values == null) {
            return this.get(defaultValue);
        }
        Object[] result2 = (Object[])Array.newInstance(clazz, values.length);
        try {
            for (int i2 = 0; i2 < values.length; ++i2) {
                result2[i2] = clazz.cast(option2.getConverter().apply(values[i2]));
            }
            return result2;
        }
        catch (Exception t2) {
            throw ParseException.wrap(t2);
        }
    }

    public <T> T[] getParsedOptionValues(Option option2, T[] defaultValue) throws ParseException {
        return this.getParsedOptionValues(option2, () -> defaultValue);
    }

    public <T> T[] getParsedOptionValues(OptionGroup optionGroup) throws ParseException {
        return this.getParsedOptionValues(optionGroup, () -> null);
    }

    public <T> T[] getParsedOptionValues(OptionGroup optionGroup, Supplier<T[]> defaultValue) throws ParseException {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return this.get(defaultValue);
        }
        return this.getParsedOptionValues(optionGroup.getSelected(), defaultValue);
    }

    public <T> T[] getParsedOptionValues(OptionGroup optionGroup, T[] defaultValue) throws ParseException {
        return this.getParsedOptionValues(optionGroup, () -> defaultValue);
    }

    public <T> T[] getParsedOptionValues(String optionName) throws ParseException {
        return this.getParsedOptionValues(this.resolveOption(optionName));
    }

    public <T> T[] getParsedOptionValues(String optionName, Supplier<T[]> defaultValue) throws ParseException {
        return this.getParsedOptionValues(this.resolveOption(optionName), defaultValue);
    }

    public <T> T[] getParsedOptionValues(String optionName, T[] defaultValue) throws ParseException {
        return this.getParsedOptionValues(this.resolveOption(optionName), defaultValue);
    }

    private void handleDeprecated(Option option2) {
        if (this.deprecatedHandler != null) {
            this.deprecatedHandler.accept(option2);
        }
    }

    public boolean hasOption(char optionChar) {
        return this.hasOption(String.valueOf(optionChar));
    }

    public boolean hasOption(Option option2) {
        boolean result2 = this.options.contains(option2);
        if (result2 && option2.isDeprecated()) {
            this.handleDeprecated(option2);
        }
        return result2;
    }

    public boolean hasOption(OptionGroup optionGroup) {
        if (optionGroup == null || !optionGroup.isSelected()) {
            return false;
        }
        return this.hasOption(optionGroup.getSelected());
    }

    public boolean hasOption(String optionName) {
        return this.hasOption(this.resolveOption(optionName));
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    private void processPropertiesFromValues(Properties props, List<String> values) {
        for (int i2 = 0; i2 < values.size(); i2 += 2) {
            if (i2 + 1 < values.size()) {
                props.put(values.get(i2), values.get(i2 + 1));
                continue;
            }
            props.put(values.get(i2), "true");
        }
    }

    private Option resolveOption(String optionName) {
        String actual = Util.stripLeadingHyphens(optionName);
        if (actual != null) {
            for (Option option2 : this.options) {
                if (!actual.equals(option2.getOpt()) && !actual.equals(option2.getLongOpt())) continue;
                return option2;
            }
        }
        return null;
    }

    public static final class Builder
    implements Supplier<CommandLine> {
        static final Consumer<Option> DEPRECATED_HANDLER = o2 -> System.out.println(o2.toDeprecatedString());
        private final List<String> args = new LinkedList<String>();
        private final List<Option> options = new ArrayList<Option>();
        private Consumer<Option> deprecatedHandler = DEPRECATED_HANDLER;

        @Deprecated
        public Builder() {
        }

        public Builder addArg(String arg) {
            if (arg != null) {
                this.args.add(arg);
            }
            return this;
        }

        public Builder addOption(Option option2) {
            if (option2 != null) {
                this.options.add(option2);
            }
            return this;
        }

        @Deprecated
        public CommandLine build() {
            return this.get();
        }

        @Override
        public CommandLine get() {
            return new CommandLine(this.args, this.options, this.deprecatedHandler);
        }

        public Builder setDeprecatedHandler(Consumer<Option> deprecatedHandler) {
            this.deprecatedHandler = deprecatedHandler;
            return this;
        }
    }
}

