/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

final class OptionValidator {
    static final char[] ADDITIONAL_OPTION_CHARS = new char[]{'?', '@'};
    static final char[] ADDITIONAL_LONG_CHARS = new char[]{'-'};

    OptionValidator() {
    }

    private static boolean isValidChar(char c2) {
        return Character.isJavaIdentifierPart(c2) || OptionValidator.search(ADDITIONAL_LONG_CHARS, c2);
    }

    private static boolean isValidOpt(char c2) {
        return Character.isJavaIdentifierPart(c2) || OptionValidator.search(ADDITIONAL_OPTION_CHARS, c2);
    }

    private static boolean search(char[] chars, char c2) {
        for (char a2 : chars) {
            if (a2 != c2) continue;
            return true;
        }
        return false;
    }

    static String validate(String option2) throws IllegalArgumentException {
        if (option2 == null) {
            return null;
        }
        if (option2.isEmpty()) {
            throw new IllegalArgumentException("Empty option name.");
        }
        char[] chars = option2.toCharArray();
        char ch0 = chars[0];
        if (!OptionValidator.isValidOpt(ch0)) {
            throw new IllegalArgumentException(String.format("Illegal option name '%s'.", Character.valueOf(ch0)));
        }
        if (option2.length() > 1) {
            for (int i2 = 1; i2 < chars.length; ++i2) {
                char ch2 = chars[i2];
                if (OptionValidator.isValidChar(ch2)) continue;
                throw new IllegalArgumentException(String.format("The option '%s' contains an illegal character : '%s'.", option2, Character.valueOf(ch2)));
            }
        }
        return option2;
    }
}

