/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.help.Util;

public final class OptionFormatter {
    private static final String[] DEFAULT_OPTIONAL_DELIMITERS = new String[]{"[", "]"};
    private static final String[] DEFAULT_ARG_NAME_DELIMITERS = new String[]{"<", ">"};
    public static final String DEFAULT_ARG_NAME = "arg";
    public static final Function<Option, String> SIMPLE_DEPRECATED_FORMAT = o2 -> "[Deprecated] " + Util.defaultValue(o2.getDescription(), "");
    public static final Function<Option, String> COMPLEX_DEPRECATED_FORMAT = o2 -> {
        StringBuilder sb = new StringBuilder("[Deprecated");
        DeprecatedAttributes attr = o2.getDeprecated();
        if (attr.isForRemoval()) {
            sb.append(" for removal");
        }
        if (!Util.isEmpty(attr.getSince())) {
            sb.append(" since ").append(attr.getSince());
        }
        if (!Util.isEmpty(attr.getDescription())) {
            sb.append(". ").append(attr.getDescription());
        }
        sb.append("]");
        if (!Util.isEmpty(o2.getDescription())) {
            sb.append(DEFAULT_OPT_ARG_SEPARATOR).append(o2.getDescription());
        }
        return sb.toString();
    };
    public static final Function<Option, String> NO_DEPRECATED_FORMAT = o2 -> Util.defaultValue(o2.getDescription(), "");
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_OPT_SEPARATOR = ", ";
    public static final String DEFAULT_OPT_ARG_SEPARATOR = " ";
    private final String[] argNameDelimiters;
    private final String defaultArgName;
    private final Function<Option, String> deprecatedFormatFunction;
    private final String longOptPrefix;
    private final String optPrefix;
    private final String optSeparator;
    private final String optArgSeparator;
    private final String[] optionalDelimiters;
    private final BiFunction<OptionFormatter, Boolean, String> syntaxFormatFunction;
    private final Option option;

    public static Builder builder() {
        return new Builder();
    }

    public static OptionFormatter from(Option option2) {
        return new Builder().build(option2);
    }

    private OptionFormatter(Option option2, Builder builder) {
        this.optionalDelimiters = builder.optionalDelimiters;
        this.argNameDelimiters = builder.argNameDelimiters;
        this.defaultArgName = builder.defaultArgName;
        this.optPrefix = builder.optPrefix;
        this.longOptPrefix = builder.longOptPrefix;
        this.optSeparator = builder.optSeparator;
        this.optArgSeparator = builder.optArgSeparator;
        this.deprecatedFormatFunction = builder.deprecatedFormatFunction;
        this.option = option2;
        this.syntaxFormatFunction = builder.syntaxFormatFunction != null ? builder.syntaxFormatFunction : (o2, required) -> {
            StringBuilder buff = new StringBuilder();
            String argName = o2.getArgName();
            buff.append(Util.defaultValue(o2.getOpt(), o2.getLongOpt()));
            if (!Util.isEmpty(argName)) {
                buff.append(this.optArgSeparator).append(argName);
            }
            boolean requiredFlg = required == null ? o2.isRequired() : required.booleanValue();
            return requiredFlg ? buff.toString() : o2.toOptional(buff.toString());
        };
    }

    public String getArgName() {
        return this.option.hasArg() ? this.argNameDelimiters[0] + Util.defaultValue(this.option.getArgName(), this.defaultArgName) + this.argNameDelimiters[1] : "";
    }

    public String getBothOpt() {
        String lOpt = this.getLongOpt();
        StringBuilder sb = new StringBuilder(this.getOpt());
        if (sb.length() > 0 && !Util.isEmpty(lOpt)) {
            sb.append(this.optSeparator);
        }
        return sb.append(this.getLongOpt()).toString();
    }

    public String getDescription() {
        return this.option.isDeprecated() ? this.deprecatedFormatFunction.apply(this.option) : Util.defaultValue(this.option.getDescription(), "");
    }

    public String getLongOpt() {
        return Util.isEmpty(this.option.getLongOpt()) ? "" : this.longOptPrefix + this.option.getLongOpt();
    }

    public String getOpt() {
        return Util.isEmpty(this.option.getOpt()) ? "" : this.optPrefix + this.option.getOpt();
    }

    public String getSince() {
        return Util.defaultValue(this.option.getSince(), DEFAULT_LONG_OPT_PREFIX);
    }

    public boolean isRequired() {
        return this.option.isRequired();
    }

    public String toOptional(String text) {
        if (Util.isEmpty(text)) {
            return "";
        }
        return this.optionalDelimiters[0] + text + this.optionalDelimiters[1];
    }

    public String toSyntaxOption() {
        return this.toSyntaxOption(this.isRequired());
    }

    public String toSyntaxOption(boolean isRequired) {
        return this.syntaxFormatFunction.apply(this, isRequired);
    }

    public static final class Builder
    implements Supplier<OptionFormatter> {
        private final String[] argNameDelimiters;
        private String defaultArgName;
        private Function<Option, String> deprecatedFormatFunction;
        private String longOptPrefix;
        private String optPrefix;
        private String optSeparator;
        private String optArgSeparator;
        private final String[] optionalDelimiters;
        private BiFunction<OptionFormatter, Boolean, String> syntaxFormatFunction;

        private Builder() {
            this.argNameDelimiters = Arrays.copyOf(DEFAULT_ARG_NAME_DELIMITERS, 2);
            this.defaultArgName = OptionFormatter.DEFAULT_ARG_NAME;
            this.deprecatedFormatFunction = NO_DEPRECATED_FORMAT;
            this.longOptPrefix = OptionFormatter.DEFAULT_LONG_OPT_PREFIX;
            this.optPrefix = OptionFormatter.DEFAULT_OPT_PREFIX;
            this.optSeparator = OptionFormatter.DEFAULT_OPT_SEPARATOR;
            this.optArgSeparator = OptionFormatter.DEFAULT_OPT_ARG_SEPARATOR;
            this.optionalDelimiters = Arrays.copyOf(DEFAULT_OPTIONAL_DELIMITERS, 2);
        }

        public Builder(OptionFormatter optionFormatter) {
            this.optionalDelimiters = Arrays.copyOf(optionFormatter.optionalDelimiters, 2);
            this.argNameDelimiters = Arrays.copyOf(optionFormatter.argNameDelimiters, 2);
            this.defaultArgName = optionFormatter.defaultArgName;
            this.optPrefix = optionFormatter.optPrefix;
            this.longOptPrefix = optionFormatter.longOptPrefix;
            this.optSeparator = optionFormatter.optSeparator;
            this.deprecatedFormatFunction = optionFormatter.deprecatedFormatFunction;
            this.syntaxFormatFunction = optionFormatter.syntaxFormatFunction;
        }

        public OptionFormatter build(Option option2) {
            return new OptionFormatter(option2, this);
        }

        @Override
        public OptionFormatter get() {
            return null;
        }

        public Builder setArgumentNameDelimiters(String begin, String end) {
            this.argNameDelimiters[0] = Util.defaultValue(begin, "");
            this.argNameDelimiters[1] = Util.defaultValue(end, "");
            return this;
        }

        public Builder setDefaultArgName(String name) {
            this.defaultArgName = Util.defaultValue(name, OptionFormatter.DEFAULT_ARG_NAME);
            return this;
        }

        public Builder setDeprecatedFormatFunction(Function<Option, String> deprecatedFormatFunction) {
            this.deprecatedFormatFunction = deprecatedFormatFunction;
            return this;
        }

        public Builder setLongOptPrefix(String prefix) {
            this.longOptPrefix = Util.defaultValue(prefix, "");
            return this;
        }

        public Builder setOptArgSeparator(String optArgSeparator) {
            this.optArgSeparator = Util.defaultValue(optArgSeparator, "");
            return this;
        }

        public Builder setOptionalDelimiters(String begin, String end) {
            this.optionalDelimiters[0] = Util.defaultValue(begin, "");
            this.optionalDelimiters[1] = Util.defaultValue(end, "");
            return this;
        }

        public Builder setOptPrefix(String optPrefix) {
            this.optPrefix = Util.defaultValue(optPrefix, "");
            return this;
        }

        public Builder setOptSeparator(String optSeparator) {
            this.optSeparator = Util.defaultValue(optSeparator, "");
            return this;
        }

        public Builder setSyntaxFormatFunction(BiFunction<OptionFormatter, Boolean, String> syntaxFormatFunction) {
            this.syntaxFormatFunction = syntaxFormatFunction;
            return this;
        }

        public String toArgName(String argName) {
            return this.argNameDelimiters[0] + Util.defaultValue(argName, "") + this.argNameDelimiters[1];
        }
    }
}

