/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Map;
import org.apache.commons.imaging.ImageReadException;

public class BasicCParser {
    private final PushbackInputStream is;

    public BasicCParser(ByteArrayInputStream is) {
        this.is = new PushbackInputStream(is);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() throws IOException, ImageReadException {
        boolean inString = false;
        boolean inIdentifier = false;
        boolean hadBackSlash = false;
        StringBuilder token = new StringBuilder();
        int c2 = this.is.read();
        while (c2 != -1) {
            block18: {
                block19: {
                    if (!inString) break block19;
                    if (c2 == 92) {
                        token.append('\\');
                        hadBackSlash = !hadBackSlash;
                        break block18;
                    } else if (c2 == 34) {
                        token.append('\"');
                        if (!hadBackSlash) {
                            return token.toString();
                        }
                        hadBackSlash = false;
                        break block18;
                    } else {
                        if (c2 == 13 || c2 == 10) {
                            throw new ImageReadException("Unterminated string in XPM file");
                        }
                        token.append((char)c2);
                        hadBackSlash = false;
                    }
                    break block18;
                }
                if (inIdentifier) {
                    if (!Character.isLetterOrDigit(c2) && c2 != 95) {
                        this.is.unread(c2);
                        return token.toString();
                    }
                    token.append((char)c2);
                } else if (c2 == 34) {
                    token.append('\"');
                    inString = true;
                } else if (Character.isLetterOrDigit(c2) || c2 == 95) {
                    token.append((char)c2);
                    inIdentifier = true;
                } else {
                    if (c2 == 123 || c2 == 125 || c2 == 91 || c2 == 93 || c2 == 42 || c2 == 59 || c2 == 61 || c2 == 44) {
                        token.append((char)c2);
                        return token.toString();
                    }
                    if (c2 != 32 && c2 != 9 && c2 != 13 && c2 != 10) {
                        throw new ImageReadException("Unhandled/invalid character '" + (char)c2 + "' found in XPM file");
                    }
                }
            }
            c2 = this.is.read();
        }
        if (inIdentifier) {
            return token.toString();
        }
        if (inString) {
            throw new ImageReadException("Unterminated string ends XMP file");
        }
        return null;
    }

    public static ByteArrayOutputStream preprocess(InputStream is, StringBuilder firstComment, Map<String, String> defines) throws IOException, ImageReadException {
        boolean inSingleQuotes = false;
        boolean inString = false;
        boolean inComment = false;
        boolean inDirective = false;
        boolean hadSlash = false;
        boolean hadStar = false;
        boolean hadBackSlash = false;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean seenFirstComment = firstComment == null;
        StringBuilder directiveBuffer = new StringBuilder();
        int c2 = is.read();
        while (c2 != -1) {
            if (inComment) {
                if (c2 == 42) {
                    if (hadStar && !seenFirstComment) {
                        firstComment.append('*');
                    }
                    hadStar = true;
                } else if (c2 == 47) {
                    if (hadStar) {
                        hadStar = false;
                        inComment = false;
                        seenFirstComment = true;
                    } else if (!seenFirstComment) {
                        firstComment.append((char)c2);
                    }
                } else {
                    if (hadStar && !seenFirstComment) {
                        firstComment.append('*');
                    }
                    hadStar = false;
                    if (!seenFirstComment) {
                        firstComment.append((char)c2);
                    }
                }
            } else if (inSingleQuotes) {
                if (c2 == 92) {
                    if (hadBackSlash) {
                        out.write(92);
                        out.write(92);
                        hadBackSlash = false;
                    } else {
                        hadBackSlash = true;
                    }
                } else if (c2 == 39) {
                    if (hadBackSlash) {
                        out.write(92);
                        hadBackSlash = false;
                    } else {
                        inSingleQuotes = false;
                    }
                    out.write(39);
                } else {
                    if (c2 == 13 || c2 == 10) {
                        throw new ImageReadException("Unterminated single quote in file");
                    }
                    if (hadBackSlash) {
                        out.write(92);
                        hadBackSlash = false;
                    }
                    out.write(c2);
                }
            } else if (inString) {
                if (c2 == 92) {
                    if (hadBackSlash) {
                        out.write(92);
                        out.write(92);
                        hadBackSlash = false;
                    } else {
                        hadBackSlash = true;
                    }
                } else if (c2 == 34) {
                    if (hadBackSlash) {
                        out.write(92);
                        hadBackSlash = false;
                    } else {
                        inString = false;
                    }
                    out.write(34);
                } else {
                    if (c2 == 13 || c2 == 10) {
                        throw new ImageReadException("Unterminated string in file");
                    }
                    if (hadBackSlash) {
                        out.write(92);
                        hadBackSlash = false;
                    }
                    out.write(c2);
                }
            } else if (inDirective) {
                if (c2 == 13 || c2 == 10) {
                    inDirective = false;
                    String[] tokens = BasicCParser.tokenizeRow(directiveBuffer.toString());
                    if (tokens.length < 2 || tokens.length > 3) {
                        throw new ImageReadException("Bad preprocessor directive");
                    }
                    if (!tokens[0].equals("define")) {
                        throw new ImageReadException("Invalid/unsupported preprocessor directive '" + tokens[0] + "'");
                    }
                    defines.put(tokens[1], tokens.length == 3 ? tokens[2] : null);
                    directiveBuffer.setLength(0);
                } else {
                    directiveBuffer.append((char)c2);
                }
            } else if (c2 == 47) {
                if (hadSlash) {
                    out.write(47);
                }
                hadSlash = true;
            } else if (c2 == 42) {
                if (hadSlash) {
                    inComment = true;
                    hadSlash = false;
                } else {
                    out.write(c2);
                }
            } else if (c2 == 39) {
                if (hadSlash) {
                    out.write(47);
                }
                hadSlash = false;
                out.write(c2);
                inSingleQuotes = true;
            } else if (c2 == 34) {
                if (hadSlash) {
                    out.write(47);
                }
                hadSlash = false;
                out.write(c2);
                inString = true;
            } else if (c2 == 35) {
                if (defines == null) {
                    throw new ImageReadException("Unexpected preprocessor directive");
                }
                inDirective = true;
            } else {
                if (hadSlash) {
                    out.write(47);
                }
                hadSlash = false;
                out.write(c2);
                if (c2 != 32 && c2 != 9 && c2 != 13 && c2 != 10) {
                    seenFirstComment = true;
                }
            }
            c2 = is.read();
        }
        if (hadSlash) {
            out.write(47);
        }
        if (hadStar) {
            out.write(42);
        }
        if (inString) {
            throw new ImageReadException("Unterminated string at the end of file");
        }
        if (inComment) {
            throw new ImageReadException("Unterminated comment at the end of file");
        }
        return out;
    }

    public static String[] tokenizeRow(String row) {
        String[] tokens = row.split("[ \t]");
        int numLiveTokens = 0;
        for (String token : tokens) {
            if (token == null || token.length() <= 0) continue;
            ++numLiveTokens;
        }
        String[] liveTokens = new String[numLiveTokens];
        int next2 = 0;
        for (String token : tokens) {
            if (token == null || token.length() <= 0) continue;
            liveTokens[next2++] = token;
        }
        return liveTokens;
    }

    public static void unescapeString(StringBuilder stringBuilder, String string2) throws ImageReadException {
        if (string2.length() < 2) {
            throw new ImageReadException("Parsing XPM file failed, string is too short");
        }
        if (string2.charAt(0) != '\"' || string2.charAt(string2.length() - 1) != '\"') {
            throw new ImageReadException("Parsing XPM file failed, string not surrounded by '\"'");
        }
        boolean hadBackSlash = false;
        for (int i2 = 1; i2 < string2.length() - 1; ++i2) {
            char c2 = string2.charAt(i2);
            if (hadBackSlash) {
                if (c2 == '\\') {
                    stringBuilder.append('\\');
                } else if (c2 == '\"') {
                    stringBuilder.append('\"');
                } else if (c2 == '\'') {
                    stringBuilder.append('\'');
                } else if (c2 == 'x') {
                    int constant;
                    if (i2 + 2 >= string2.length()) {
                        throw new ImageReadException("Parsing XPM file failed, hex constant in string too short");
                    }
                    char hex1 = string2.charAt(i2 + 1);
                    char hex2 = string2.charAt(i2 + 2);
                    i2 += 2;
                    try {
                        constant = Integer.parseInt(Character.toString(hex1) + Character.toString(hex2), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ImageReadException("Parsing XPM file failed, hex constant invalid", nfe);
                    }
                    stringBuilder.append((char)constant);
                } else if (c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7') {
                    int length = 1;
                    if (i2 + 1 < string2.length() && '0' <= string2.charAt(i2 + 1) && string2.charAt(i2 + 1) <= '7') {
                        ++length;
                    }
                    if (i2 + 2 < string2.length() && '0' <= string2.charAt(i2 + 2) && string2.charAt(i2 + 2) <= '7') {
                        ++length;
                    }
                    int constant = 0;
                    for (int j2 = 0; j2 < length; ++j2) {
                        constant *= 8;
                        constant += string2.charAt(i2 + j2) - 48;
                    }
                    i2 += length - 1;
                    stringBuilder.append((char)constant);
                } else if (c2 == 'a') {
                    stringBuilder.append('\u0007');
                } else if (c2 == 'b') {
                    stringBuilder.append('\b');
                } else if (c2 == 'f') {
                    stringBuilder.append('\f');
                } else if (c2 == 'n') {
                    stringBuilder.append('\n');
                } else if (c2 == 'r') {
                    stringBuilder.append('\r');
                } else if (c2 == 't') {
                    stringBuilder.append('\t');
                } else if (c2 == 'v') {
                    stringBuilder.append('\u000b');
                } else {
                    throw new ImageReadException("Parsing XPM file failed, invalid escape sequence");
                }
                hadBackSlash = false;
                continue;
            }
            if (c2 == '\\') {
                hadBackSlash = true;
                continue;
            }
            if (c2 == '\"') {
                throw new ImageReadException("Parsing XPM file failed, extra '\"' found in string");
            }
            stringBuilder.append(c2);
        }
        if (hadBackSlash) {
            throw new ImageReadException("Parsing XPM file failed, unterminated escape sequence found in string");
        }
    }
}

