/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import java.util.Properties;

public class ImageBuilder {
    private final int[] data;
    private final int width;
    private final int height;
    private final boolean hasAlpha;

    public ImageBuilder(int width, int height, boolean hasAlpha) {
        if (width <= 0) {
            throw new RasterFormatException("zero or negative width value");
        }
        if (height <= 0) {
            throw new RasterFormatException("zero or negative height value");
        }
        this.data = new int[width * height];
        this.width = width;
        this.height = height;
        this.hasAlpha = hasAlpha;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRGB(int x2, int y2) {
        int rowOffset = y2 * this.width;
        return this.data[rowOffset + x2];
    }

    public void setRGB(int x2, int y2, int argb) {
        int rowOffset = y2 * this.width;
        this.data[rowOffset + x2] = argb;
    }

    public BufferedImage getBufferedImage() {
        return this.makeBufferedImage(this.data, this.width, this.height, this.hasAlpha);
    }

    public BufferedImage getSubimage(int x2, int y2, int w2, int h7) {
        if (w2 <= 0) {
            throw new RasterFormatException("negative or zero subimage width");
        }
        if (h7 <= 0) {
            throw new RasterFormatException("negative or zero subimage height");
        }
        if (x2 < 0 || x2 >= this.width) {
            throw new RasterFormatException("subimage x is outside raster");
        }
        if (x2 + w2 > this.width) {
            throw new RasterFormatException("subimage (x+width) is outside raster");
        }
        if (y2 < 0 || y2 >= this.height) {
            throw new RasterFormatException("subimage y is outside raster");
        }
        if (y2 + h7 > this.height) {
            throw new RasterFormatException("subimage (y+height) is outside raster");
        }
        int[] argb = new int[w2 * h7];
        int k2 = 0;
        for (int iRow = 0; iRow < h7; ++iRow) {
            int dIndex = (iRow + y2) * this.width + x2;
            System.arraycopy(this.data, dIndex, argb, k2, w2);
            k2 += w2;
        }
        return this.makeBufferedImage(argb, w2, h7, this.hasAlpha);
    }

    private BufferedImage makeBufferedImage(int[] argb, int w2, int h7, boolean useAlpha) {
        WritableRaster raster;
        DirectColorModel colorModel;
        DataBufferInt buffer = new DataBufferInt(argb, w2 * h7);
        if (useAlpha) {
            colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            raster = Raster.createPackedRaster(buffer, w2, h7, w2, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        } else {
            colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
            raster = Raster.createPackedRaster(buffer, w2, h7, w2, new int[]{0xFF0000, 65280, 255}, null);
        }
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), new Properties());
    }
}

