/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.mylzw;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.common.mylzw.MyBitInputStream;

public class BitsToByteInputStream
extends InputStream {
    private final MyBitInputStream is;
    private final int desiredDepth;

    public BitsToByteInputStream(MyBitInputStream is, int desiredDepth) {
        this.is = is;
        this.desiredDepth = desiredDepth;
    }

    @Override
    public int read() throws IOException {
        return this.readBits(8);
    }

    public int readBits(int bitCount) throws IOException {
        int i2 = this.is.readBits(bitCount);
        if (bitCount < this.desiredDepth) {
            i2 <<= this.desiredDepth - bitCount;
        } else if (bitCount > this.desiredDepth) {
            i2 >>= bitCount - this.desiredDepth;
        }
        return i2;
    }

    public int[] readBitsArray(int sampleBits, int length) throws IOException {
        int[] result2 = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result2[i2] = this.readBits(sampleBits);
        }
        return result2;
    }
}

