/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;
import org.apache.commons.imaging.formats.bmp.PixelParser;

class PixelParserRle
extends PixelParser {
    public PixelParserRle(BmpHeaderInfo bhi, byte[] colorTable, byte[] imageData) {
        super(bhi, colorTable, imageData);
    }

    private int getSamplesPerByte() throws ImageReadException {
        if (this.bhi.bitsPerPixel == 8) {
            return 1;
        }
        if (this.bhi.bitsPerPixel == 4) {
            return 2;
        }
        throw new ImageReadException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
    }

    private int[] convertDataToSamples(int data) throws ImageReadException {
        int[] rgbs;
        if (this.bhi.bitsPerPixel == 8) {
            rgbs = new int[]{this.getColorTableRGB(data)};
        } else if (this.bhi.bitsPerPixel == 4) {
            rgbs = new int[2];
            int sample1 = data >> 4;
            int sample2 = 0xF & data;
            rgbs[0] = this.getColorTableRGB(sample1);
            rgbs[1] = this.getColorTableRGB(sample2);
        } else {
            throw new ImageReadException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
        }
        return rgbs;
    }

    private int processByteOfData(int[] rgbs, int repeat, int x2, int y2, int width, int height, ImageBuilder imageBuilder) {
        int pixelsWritten = 0;
        for (int i2 = 0; i2 < repeat; ++i2) {
            if (x2 >= 0 && x2 < width && y2 >= 0 && y2 < height) {
                int rgb = rgbs[i2 % rgbs.length];
                imageBuilder.setRGB(x2, y2, rgb);
            } else {
                System.out.println("skipping bad pixel (" + x2 + "," + y2 + ")");
            }
            ++x2;
            ++pixelsWritten;
        }
        return pixelsWritten;
    }

    @Override
    public void processImage(ImageBuilder imageBuilder) throws ImageReadException, IOException {
        int width = this.bhi.width;
        int height = this.bhi.height;
        int x2 = 0;
        int y2 = height - 1;
        boolean done = false;
        block5: while (!done) {
            int a2 = 0xFF & BinaryFunctions.readByte("RLE (" + x2 + "," + y2 + ") a", this.is, "BMP: Bad RLE");
            int b2 = 0xFF & BinaryFunctions.readByte("RLE (" + x2 + "," + y2 + ") b", this.is, "BMP: Bad RLE");
            if (a2 == 0) {
                switch (b2) {
                    case 0: {
                        --y2;
                        x2 = 0;
                        continue block5;
                    }
                    case 1: {
                        done = true;
                        continue block5;
                    }
                    case 2: {
                        int deltaX = 0xFF & BinaryFunctions.readByte("RLE deltaX", this.is, "BMP: Bad RLE");
                        int deltaY = 0xFF & BinaryFunctions.readByte("RLE deltaY", this.is, "BMP: Bad RLE");
                        x2 += deltaX;
                        y2 -= deltaY;
                        continue block5;
                    }
                }
                int samplesPerByte = this.getSamplesPerByte();
                int size = b2 / samplesPerByte;
                if (b2 % samplesPerByte > 0) {
                    ++size;
                }
                if (size % 2 != 0) {
                    ++size;
                }
                byte[] bytes = BinaryFunctions.readBytes("bytes", this.is, size, "RLE: Absolute Mode");
                int remaining = b2;
                int i2 = 0;
                while (remaining > 0) {
                    int[] samples = this.convertDataToSamples(0xFF & bytes[i2]);
                    int towrite = Math.min(remaining, samplesPerByte);
                    int written = this.processByteOfData(samples, towrite, x2, y2, width, height, imageBuilder);
                    x2 += written;
                    remaining -= written;
                    ++i2;
                }
                continue;
            }
            int[] rgbs = this.convertDataToSamples(b2);
            x2 += this.processByteOfData(rgbs, a2, x2, y2, width, height, imageBuilder);
        }
    }
}

