/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

final class YCbCrConverter {
    private static final int[] REDS;
    private static final int[] BLUES;
    private static final int[] GREENS1;
    private static final int[] GREENS2;

    private YCbCrConverter() {
    }

    private static int fastRound(float x2) {
        return (int)(x2 + 0.5f);
    }

    public static int convertYCbCrToRGB(int Y2, int Cb, int Cr) {
        int r2 = REDS[Cr << 8 | Y2];
        int g1 = GREENS1[Cb << 8 | Cr];
        int g2 = GREENS2[g1 << 8 | Y2];
        int b2 = BLUES[Cb << 8 | Y2];
        return r2 | g2 | b2;
    }

    static {
        int Cr;
        int Y2;
        REDS = new int[65536];
        BLUES = new int[65536];
        GREENS1 = new int[65536];
        GREENS2 = new int[131072];
        for (Y2 = 0; Y2 < 256; ++Y2) {
            for (Cr = 0; Cr < 256; ++Cr) {
                int r2 = Y2 + YCbCrConverter.fastRound(1.402f * (float)(Cr - 128));
                if (r2 < 0) {
                    r2 = 0;
                }
                if (r2 > 255) {
                    r2 = 255;
                }
                YCbCrConverter.REDS[Cr << 8 | Y2] = r2 << 16;
            }
        }
        for (Y2 = 0; Y2 < 256; ++Y2) {
            for (int Cb = 0; Cb < 256; ++Cb) {
                int b2 = Y2 + YCbCrConverter.fastRound(1.772f * (float)(Cb - 128));
                if (b2 < 0) {
                    b2 = 0;
                }
                if (b2 > 255) {
                    b2 = 255;
                }
                YCbCrConverter.BLUES[Cb << 8 | Y2] = b2;
            }
        }
        for (int Cb = 0; Cb < 256; ++Cb) {
            for (Cr = 0; Cr < 256; ++Cr) {
                int value = YCbCrConverter.fastRound(0.34414f * (float)(Cb - 128) + 0.71414f * (float)(Cr - 128));
                YCbCrConverter.GREENS1[Cb << 8 | Cr] = value + 135;
            }
        }
        for (Y2 = 0; Y2 < 256; ++Y2) {
            for (int value = 0; value < 270; ++value) {
                int green = Y2 - (value - 135);
                if (green < 0) {
                    green = 0;
                } else if (green > 255) {
                    green = 255;
                }
                YCbCrConverter.GREENS2[value << 8 | Y2] = green << 8;
            }
        }
    }
}

