/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;

public class DhtSegment
extends Segment {
    public final List<HuffmanTable> huffmanTables;

    public DhtSegment(int marker, byte[] segmentData) throws IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public DhtSegment(int marker, int length, InputStream is) throws IOException {
        super(marker, length);
        ArrayList<HuffmanTable> huffmanTables = new ArrayList<HuffmanTable>();
        while (length > 0) {
            int tableClassAndDestinationId = 0xFF & BinaryFunctions.readByte("TableClassAndDestinationId", is, "Not a Valid JPEG File");
            --length;
            int tableClass = tableClassAndDestinationId >> 4 & 0xF;
            int destinationIdentifier = tableClassAndDestinationId & 0xF;
            int[] bits = new int[17];
            int bitsSum = 0;
            for (int i2 = 1; i2 < bits.length; ++i2) {
                bits[i2] = 0xFF & BinaryFunctions.readByte("Li", is, "Not a Valid JPEG File");
                --length;
                bitsSum += bits[i2];
            }
            int[] huffVal = new int[bitsSum];
            for (int i3 = 0; i3 < bitsSum; ++i3) {
                huffVal[i3] = 0xFF & BinaryFunctions.readByte("Vij", is, "Not a Valid JPEG File");
                --length;
            }
            huffmanTables.add(new HuffmanTable(tableClass, destinationIdentifier, bits, huffVal));
        }
        this.huffmanTables = Collections.unmodifiableList(huffmanTables);
    }

    @Override
    public String getDescription() {
        return "DHT (" + this.getSegmentType() + ")";
    }

    public static class HuffmanTable {
        public final int tableClass;
        public final int destinationIdentifier;
        private final int[] huffVal;
        private final int[] huffSize = new int[4096];
        private final int[] huffCode;
        private final int[] minCode = new int[17];
        private final int[] maxCode = new int[17];
        private final int[] valPtr = new int[17];

        HuffmanTable(int tableClass, int destinationIdentifier, int[] bits, int[] huffVal) {
            this.tableClass = tableClass;
            this.destinationIdentifier = destinationIdentifier;
            this.huffVal = huffVal;
            int k2 = 0;
            int i2 = 1;
            int j2 = 1;
            int lastK = -1;
            while (true) {
                if (j2 > bits[i2]) {
                    j2 = 1;
                    if (++i2 <= 16) continue;
                    break;
                }
                this.huffSize[k2] = i2;
                ++k2;
                ++j2;
            }
            this.huffSize[k2] = 0;
            lastK = k2;
            k2 = 0;
            int code2 = 0;
            int si = this.huffSize[0];
            this.huffCode = new int[lastK];
            while (k2 < lastK) {
                this.huffCode[k2] = code2++;
                if (this.huffSize[++k2] == si) continue;
                if (this.huffSize[k2] == 0) break;
                do {
                    code2 <<= 1;
                } while (this.huffSize[k2] != ++si);
            }
            i2 = 0;
            j2 = 0;
            while (++i2 <= 16) {
                if (bits[i2] == 0) {
                    this.maxCode[i2] = -1;
                    continue;
                }
                this.valPtr[i2] = j2;
                this.minCode[i2] = this.huffCode[j2];
                this.maxCode[i2] = this.huffCode[j2 += bits[i2] - 1];
                ++j2;
            }
        }

        public int getHuffVal(int i2) {
            return this.huffVal[i2];
        }

        public int getMinCode(int i2) {
            return this.minCode[i2];
        }

        public int getMaxCode(int i2) {
            return this.maxCode[i2];
        }

        public int getValPtr(int i2) {
            return this.valPtr[i2];
        }
    }
}

