/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeLong
extends FieldType {
    public FieldTypeLong(int type, String name) {
        super(type, name, 4);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toInt(bytes, entry.getByteOrder());
        }
        return ByteConversions.toInts(bytes, entry.getByteOrder());
    }

    @Override
    public byte[] writeData(Object o2, ByteOrder byteOrder) throws ImageWriteException {
        if (o2 instanceof Integer) {
            return ByteConversions.toBytes((Integer)o2, byteOrder);
        }
        if (o2 instanceof int[]) {
            int[] numbers = (int[])o2;
            return ByteConversions.toBytes(numbers, byteOrder);
        }
        if (o2 instanceof Integer[]) {
            Integer[] numbers = (Integer[])o2;
            int[] values = new int[numbers.length];
            for (int i2 = 0; i2 < values.length; ++i2) {
                values[i2] = numbers[i2];
            }
            return ByteConversions.toBytes(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data", o2);
    }
}

