/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.util.ArrayListWrapper;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class PropertyExecutor
extends AbstractExecutor {
    private final Introspector introspector;
    private final boolean wrapArray;

    public PropertyExecutor(Logger log2, Introspector introspector, Class<?> clazz, String property) {
        this(log2, introspector, clazz, property, false);
    }

    public PropertyExecutor(Logger log2, Introspector introspector, Class<?> clazz, String property, boolean wrapArray) {
        this.log = log2;
        this.introspector = introspector;
        this.wrapArray = wrapArray;
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.discover(clazz, property);
        }
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class<?> clazz, String property) {
        try {
            Object[] params = new Object[]{};
            StringBuilder sb = new StringBuilder("get");
            sb.append(property);
            this.setMethod(this.introspector.getMethod(clazz, sb.toString(), params));
            if (!this.isAlive()) {
                char c2 = sb.charAt(3);
                if (Character.isLowerCase(c2)) {
                    sb.setCharAt(3, Character.toUpperCase(c2));
                } else {
                    sb.setCharAt(3, Character.toLowerCase(c2));
                }
                this.setMethod(this.introspector.getMethod(clazz, sb.toString(), params));
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            String msg = "Exception while looking for property getter for '" + property;
            this.log.error(msg, (Throwable)e3);
            throw new VelocityException(msg, e3);
        }
    }

    @Override
    public Object execute(Object o2) throws IllegalAccessException, InvocationTargetException {
        if (this.wrapArray) {
            o2 = new ArrayListWrapper(o2);
        }
        return this.isAlive() ? this.getMethod().invoke(o2, (Object[])null) : null;
    }
}

