/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.NodeUtils;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.util.StringUtils;
import org.slf4j.Logger;

public class SimpleNode
implements Node {
    protected RuntimeServices rsvc = null;
    protected Logger log = null;
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    protected int info;
    public boolean state;
    protected boolean invalid = false;
    protected Token first;
    protected Token last;
    protected Template template;
    protected String literal = null;
    protected int line;
    protected int column;
    protected String firstImage;
    protected String lastImage;

    public RuntimeServices getRuntimeServices() {
        return this.rsvc;
    }

    public SimpleNode(int i2) {
        this.id = i2;
    }

    public SimpleNode(Parser p2, int i2) {
        this(i2);
        this.parser = p2;
        this.template = this.parser.getCurrentTemplate();
    }

    @Override
    public void jjtOpen() {
        this.first = this.parser.getToken(1);
    }

    @Override
    public void jjtClose() {
        this.last = this.parser.getToken(0);
    }

    public void setFirstToken(Token t2) {
        this.first = t2;
    }

    @Override
    public Token getFirstToken() {
        return this.first;
    }

    @Override
    public Token getLastToken() {
        return this.last;
    }

    @Override
    public void jjtSetParent(Node n2) {
        this.parent = n2;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n2, int i2) {
        if (this.children == null) {
            this.children = new Node[i2 + 1];
        } else if (i2 >= this.children.length) {
            Node[] c2 = new Node[i2 + 1];
            System.arraycopy(this.children, 0, c2, 0, this.children.length);
            this.children = c2;
        }
        this.children[i2] = n2;
    }

    @Override
    public Node jjtGetChild(int i2) {
        return this.children[i2];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object childrenAccept(ParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (Node aChildren : this.children) {
                aChildren.jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString(String prefix) {
        return prefix + "_" + this.toString();
    }

    public final void dump(String prefix) {
        this.dump(prefix, System.out);
    }

    public final void dump(String prefix, PrintStream out) {
        Charset charset = null;
        if (this.rsvc != null) {
            String encoding = this.rsvc.getString("resource.default_encoding");
            try {
                charset = Charset.forName(encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, charset));
        this.dump(prefix, pw);
        pw.flush();
    }

    public void dump(String prefix, PrintWriter out) {
        out.println(this.toString());
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                SimpleNode n2 = (SimpleNode)this.children[i2];
                out.print(prefix + " |_");
                if (n2 == null) continue;
                n2.dump(prefix + (i2 == this.children.length - 1 ? "   " : " | "), out);
            }
        }
    }

    protected String getLocation(InternalContextAdapter context) {
        return StringUtils.formatFileString(this);
    }

    @Override
    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        if (this.first == this.last) {
            this.literal = NodeUtils.tokenLiteral(this.parser, this.first);
            return this.literal;
        }
        Token t2 = this.first;
        StringBuilder sb = new StringBuilder(NodeUtils.tokenLiteral(this.parser, t2));
        while (t2 != this.last) {
            t2 = t2.next;
            sb.append(NodeUtils.tokenLiteral(this.parser, t2));
        }
        this.literal = sb.toString();
        return this.literal;
    }

    @Override
    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        this.rsvc = (RuntimeServices)data;
        this.log = this.rsvc.getLog("rendering");
        int k2 = this.jjtGetNumChildren();
        for (int i2 = 0; i2 < k2; ++i2) {
            this.jjtGetChild(i2).init(context, data);
        }
        this.line = this.first.beginLine;
        this.column = this.first.beginColumn;
        return data;
    }

    @Override
    public boolean evaluate(InternalContextAdapter context) throws MethodInvocationException {
        return false;
    }

    @Override
    public Object value(InternalContextAdapter context) throws MethodInvocationException {
        return null;
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException, ParseErrorException, ResourceNotFoundException {
        int k2 = this.jjtGetNumChildren();
        for (int i2 = 0; i2 < k2; ++i2) {
            this.jjtGetChild(i2).render(context, writer);
        }
        return true;
    }

    @Override
    public Object execute(Object o2, InternalContextAdapter context) throws MethodInvocationException {
        return null;
    }

    @Override
    public int getType() {
        return this.id;
    }

    @Override
    public void setInfo(int info) {
        this.info = info;
    }

    @Override
    public int getInfo() {
        return this.info;
    }

    @Override
    public void setInvalid() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public String toString() {
        String tok;
        StringBuilder tokens = new StringBuilder();
        Token t2 = this.getFirstToken();
        while (t2 != null) {
            tokens.append("[").append(t2.image.replace("\n", "\\n")).append("]");
            if (t2.next != null) {
                if (t2.equals(this.getLastToken())) break;
                tokens.append(", ");
            }
            t2 = t2.next;
        }
        if ((tok = tokens.toString()).length() > 50) {
            tok = tok.substring(0, 50) + "...";
        }
        return this.getClass().getSimpleName() + " [id=" + this.id + ", info=" + this.info + ", invalid=" + this.invalid + ", tokens=" + tok + "]";
    }

    @Override
    public String getTemplateName() {
        return this.template.getName();
    }

    public void saveTokenImages() {
        if (this.first != null) {
            this.firstImage = this.first.image;
        }
        if (this.last != null) {
            this.lastImage = this.last.image;
        }
    }

    public void cleanupParserAndTokens() {
        this.parser = null;
        this.first = null;
        this.last = null;
    }

    @Override
    public String getFirstTokenImage() {
        return this.firstImage;
    }

    @Override
    public String getLastTokenImage() {
        return this.lastImage;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }
}

