/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExtProperties;

public class ClasspathResourceLoader
extends ResourceLoader {
    @Override
    public void init(ExtProperties configuration) {
        this.log.trace("ClasspathResourceLoader: initialization complete.");
    }

    @Override
    public Reader getResourceReader(String name, String encoding) throws ResourceNotFoundException {
        Reader result2 = null;
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        InputStream rawStream = null;
        try {
            rawStream = ClassUtils.getResourceAsStream(this.getClass(), name);
            if (rawStream != null) {
                result2 = this.buildReader(rawStream, encoding);
            }
        }
        catch (Exception fnfe) {
            if (rawStream != null) {
                try {
                    rawStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ResourceNotFoundException("ClasspathResourceLoader problem with template: " + name, fnfe, this.rsvc.getLogContext().getStackTrace());
        }
        if (result2 == null) {
            String msg = "ClasspathResourceLoader Error: cannot find resource " + name;
            throw new ResourceNotFoundException(msg, null, this.rsvc.getLogContext().getStackTrace());
        }
        return result2;
    }

    @Override
    public boolean isSourceModified(Resource resource2) {
        return false;
    }

    @Override
    public long getLastModified(Resource resource2) {
        return 0L;
    }
}

