/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Objects;
import org.assertj.core.description.Description;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Strings;

public class MessageFormatter {
    private static final MessageFormatter INSTANCE = new MessageFormatter();
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static MessageFormatter instance() {
        return INSTANCE;
    }

    MessageFormatter() {
    }

    public String format(Description d2, Representation p2, String format2, Object ... args) {
        Objects.requireNonNull(format2);
        Objects.requireNonNull(args);
        return this.descriptionFormatter.format(d2) + Strings.formatIfArgs(format2, this.format(p2, args));
    }

    private Object[] format(Representation p2, Object[] args) {
        int argCount = args.length;
        Object[] formatted = new String[argCount];
        for (int i2 = 0; i2 < argCount; ++i2) {
            formatted[i2] = this.asText(p2, args[i2]);
        }
        return formatted;
    }

    private String asText(Representation p2, Object o2) {
        if (o2 instanceof AbstractComparisonStrategy) {
            AbstractComparisonStrategy strategy = (AbstractComparisonStrategy)o2;
            return strategy.asText();
        }
        return p2.toStringOf(o2);
    }
}

