/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.FileVisitOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEmptyDirectory;
import org.assertj.core.error.ShouldBeExecutable;
import org.assertj.core.error.ShouldBeFile;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainRecursively;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveExtension;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoExtension;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.NioFilesWrapper;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.diff.Delta;

public class Files {
    private static final String UNABLE_TO_COMPARE_FILE_CONTENTS = "Unable to compare contents of files:<%s> and:<%s>";
    private static final Files INSTANCE = new Files();
    private static final FileFilter ANY = any2 -> true;
    Diff diff = new Diff();
    BinaryDiff binaryDiff = new BinaryDiff();
    Failures failures = Failures.instance();
    NioFilesWrapper nioFilesWrapper = NioFilesWrapper.instance();

    public static Files instance() {
        return INSTANCE;
    }

    Files() {
    }

    public void assertSameContentAs(AssertionInfo info, File actual, Charset actualCharset, File expected, Charset expectedCharset) {
        this.verifyIsFile(expected);
        this.assertIsFile(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (MalformedInputException e2) {
            try {
                BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected.toPath()));
                if (binaryDiffResult.hasNoDiff()) {
                    throw e2;
                }
                throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(UNABLE_TO_COMPARE_FILE_CONTENTS.formatted(actual, expected), ioe);
            }
        }
        catch (IOException e3) {
            throw new UncheckedIOException(UNABLE_TO_COMPARE_FILE_CONTENTS.formatted(actual, expected), e3);
        }
    }

    public void assertSameBinaryContentAs(AssertionInfo info, File actual, File expected) {
        this.verifyIsFile(expected);
        this.assertIsFile(info, actual);
        try {
            BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected.toPath()));
            if (binaryDiffResult.hasDiff()) {
                throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(UNABLE_TO_COMPARE_FILE_CONTENTS.formatted(actual, expected), ioe);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info, File actual, byte[] expected) {
        java.util.Objects.requireNonNull(expected, "The binary content to compare to should not be null");
        this.assertIsFile(info, actual);
        try {
            BinaryDiffResult result2 = this.binaryDiff.diff(actual, expected);
            if (result2.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, result2));
        }
        catch (IOException e2) {
            String msg = "Unable to verify binary contents of file:<%s>".formatted(actual);
            throw new UncheckedIOException(msg, e2);
        }
    }

    public void assertHasSizeInBytes(AssertionInfo info, File actual, long expectedSizeInBytes) {
        this.assertIsFile(info, actual);
        if (expectedSizeInBytes == actual.length()) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSize.shouldHaveSize(actual, expectedSizeInBytes));
    }

    public void assertHasContent(AssertionInfo info, File actual, String expected, Charset charset) {
        java.util.Objects.requireNonNull(expected, "The text to compare to should not be null");
        this.assertIsFile(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e2) {
            String msg = "Unable to verify text contents of file:<%s>".formatted(actual);
            throw new UncheckedIOException(msg, e2);
        }
    }

    public void assertIsFile(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.isFile()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeFile.shouldBeFile(actual));
    }

    public void assertIsDirectory(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.isDirectory()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeDirectory.shouldBeDirectory(actual));
    }

    public void assertIsAbsolute(AssertionInfo info, File actual) {
        if (this.isAbsolutePath(info, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
    }

    public void assertIsRelative(AssertionInfo info, File actual) {
        if (!this.isAbsolutePath(info, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeRelativePath.shouldBeRelativePath(actual));
    }

    public void assertExists(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.exists()) {
            return;
        }
        throw this.failures.failure(info, ShouldExist.shouldExist(actual));
    }

    public void assertDoesNotExist(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (!actual.exists()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotExist.shouldNotExist(actual));
    }

    public void assertCanWrite(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canWrite()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWritable.shouldBeWritable(actual));
    }

    public void assertIsEmptyFile(AssertionInfo info, File actual) {
        this.assertIsFile(info, actual);
        if (actual.length() == 0L) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertIsNotEmptyFile(AssertionInfo info, File actual) {
        this.assertIsFile(info, actual);
        if (actual.length() > 0L) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty(actual));
    }

    public void assertCanRead(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canRead()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeReadable.shouldBeReadable(actual));
    }

    public void assertIsExecutable(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canExecute()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeExecutable.shouldBeExecutable(actual));
    }

    public void assertHasParent(AssertionInfo info, File actual, File expected) {
        java.util.Objects.requireNonNull(expected, "The expected parent file should not be null.");
        Files.assertNotNull(info, actual);
        try {
            if (actual.getParentFile() != null && java.util.Objects.equals(expected.getCanonicalFile(), actual.getParentFile().getCanonicalFile())) {
                return;
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException("Unable to get canonical form of [%s] or [%s].".formatted(actual, expected), e2);
        }
        throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, expected));
    }

    public void assertHasExtension(AssertionInfo info, File actual, String expected) {
        java.util.Objects.requireNonNull(expected, "The expected extension should not be null.");
        this.assertIsFile(info, actual);
        String extension = this.getFileExtension(actual).orElseThrow(() -> this.failures.failure(info, ShouldHaveExtension.shouldHaveExtension(actual, expected)));
        if (!expected.equals(extension)) {
            throw this.failures.failure(info, ShouldHaveExtension.shouldHaveExtension(actual, extension, expected));
        }
    }

    public void assertHasNoExtension(AssertionInfo info, File actual) {
        this.assertIsFile(info, actual);
        Optional<String> extension = this.getFileExtension(actual);
        if (extension.isPresent()) {
            throw this.failures.failure(info, ShouldHaveNoExtension.shouldHaveNoExtension(actual, extension.get()));
        }
    }

    public void assertHasName(AssertionInfo info, File actual, String expected) {
        Files.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(expected, "The expected name should not be null.");
        if (expected.equals(actual.getName())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveName.shouldHaveName(actual, expected));
    }

    public void assertHasNoParent(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.getParentFile() == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoParent.shouldHaveNoParent(actual));
    }

    public void assertHasDigest(AssertionInfo info, File actual, MessageDigest digest, byte[] expected) {
        java.util.Objects.requireNonNull(digest, "The message digest algorithm should not be null");
        java.util.Objects.requireNonNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertExists(info, actual);
        this.assertIsFile(info, actual);
        this.assertCanRead(info, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual.toPath(), new OpenOption[0]);){
            DigestDiff digestDiff = Digests.digestDiff(actualStream, digest, expected);
            if (digestDiff.digestsDiffer()) {
                throw this.failures.failure(info, ShouldHaveDigest.shouldHaveDigest(actual, digestDiff));
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException("Unable to calculate digest of path:<%s>".formatted(actual), e2);
        }
    }

    public void assertHasDigest(AssertionInfo info, File actual, MessageDigest digest, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info, File actual, String algorithm, byte[] expected) {
        java.util.Objects.requireNonNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalStateException("Unable to find digest implementation for: <%s>".formatted(algorithm), e2);
        }
    }

    public void assertHasDigest(AssertionInfo info, File actual, String algorithm, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, algorithm, Digests.fromHex(expected));
    }

    public void assertIsEmptyDirectory(AssertionInfo info, File actual) {
        List<File> files = this.directoryContent(info, actual);
        if (!files.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEmptyDirectory.shouldBeEmptyDirectory(actual, files));
        }
    }

    public void assertIsNotEmptyDirectory(AssertionInfo info, File actual) {
        boolean isEmptyDirectory = this.directoryContent(info, actual).isEmpty();
        if (isEmptyDirectory) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public void assertIsDirectoryContaining(AssertionInfo info, File actual, Predicate<File> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryContaining(info, actual, filter2::test, "the given filter");
    }

    public void assertIsDirectoryContaining(AssertionInfo info, File actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        FileFilter filter2 = Files.fileFilter(info, actual, syntaxAndPattern);
        this.assertIsDirectoryContaining(info, actual, filter2, "the '%s' pattern".formatted(syntaxAndPattern));
    }

    public void assertIsDirectoryRecursivelyContaining(AssertionInfo info, File actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        FileFilter filter2 = Files.fileFilter(info, actual, syntaxAndPattern);
        this.assertIsDirectoryRecursivelyContaining(info, actual, filter2::accept, "the '%s' pattern".formatted(syntaxAndPattern));
    }

    public void assertIsDirectoryRecursivelyContaining(AssertionInfo info, File actual, Predicate<File> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryRecursivelyContaining(info, actual, filter2, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info, File actual, Predicate<File> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryNotContaining(info, actual, filter2::test, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info, File actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        FileFilter filter2 = Files.fileFilter(info, actual, syntaxAndPattern);
        this.assertIsDirectoryNotContaining(info, actual, filter2, "the '%s' pattern".formatted(syntaxAndPattern));
    }

    private List<File> filterDirectory(AssertionInfo info, File actual, FileFilter filter2) {
        this.assertIsDirectory(info, actual);
        File[] items = actual.listFiles(filter2);
        java.util.Objects.requireNonNull(items, "Directory listing should not be null");
        List<File> files = Lists.list(items);
        files.sort(Comparator.comparing(File::toString));
        return files;
    }

    private List<File> directoryContent(AssertionInfo info, File actual) {
        return this.filterDirectory(info, actual, ANY);
    }

    private void assertIsDirectoryContaining(AssertionInfo info, File actual, FileFilter filter2, String filterPresentation) {
        List<File> matchingFiles = this.filterDirectory(info, actual, filter2);
        if (matchingFiles.isEmpty()) {
            throw this.failures.failure(info, ShouldContain.directoryShouldContain(actual, this.directoryContent(info, actual), filterPresentation));
        }
    }

    private void assertIsDirectoryNotContaining(AssertionInfo info, File actual, FileFilter filter2, String filterPresentation) {
        List<File> matchingFiles = this.filterDirectory(info, actual, filter2);
        if (!matchingFiles.isEmpty()) {
            throw this.failures.failure(info, ShouldNotContain.directoryShouldNotContain(actual, matchingFiles, filterPresentation));
        }
    }

    private boolean isDirectoryRecursivelyContaining(AssertionInfo info, File actual, Predicate<File> filter2) {
        this.assertIsDirectory(info, actual);
        try (Stream<File> actualContent = this.recursiveContentOf(actual);){
            boolean bl2 = actualContent.anyMatch(filter2);
            return bl2;
        }
    }

    private List<File> sortedRecursiveContent(File directory) {
        try (Stream<File> fileStream = this.recursiveContentOf(directory);){
            List<File> list = fileStream.sorted(Comparator.comparing(File::getAbsolutePath)).collect(Collectors.toList());
            return list;
        }
    }

    private Stream<File> recursiveContentOf(File directory) {
        Path path = directory.toPath();
        try {
            return java.nio.file.Files.walk(path, new FileVisitOption[0]).filter(p2 -> !p2.equals(path)).map(Path::toFile);
        }
        catch (IOException e2) {
            throw new UncheckedIOException("Unable to walk recursively the directory :<%s>".formatted(path), e2);
        }
    }

    private void assertIsDirectoryRecursivelyContaining(AssertionInfo info, File actual, Predicate<File> filter2, String filterPresentation) {
        if (!this.isDirectoryRecursivelyContaining(info, actual, filter2)) {
            throw this.failures.failure(info, ShouldContainRecursively.directoryShouldContainRecursively(actual, this.sortedRecursiveContent(actual), filterPresentation));
        }
    }

    private static FileFilter fileFilter(AssertionInfo info, File actual, String syntaxAndPattern) {
        Files.assertNotNull(info, actual);
        PathMatcher matcher = actual.toPath().getFileSystem().getPathMatcher(syntaxAndPattern);
        return file -> matcher.matches(file.toPath());
    }

    private static void assertNotNull(AssertionInfo info, File actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private Optional<String> getFileExtension(File file) {
        return org.assertj.core.util.Files.getFileNameExtension(file.getName());
    }

    private void verifyIsFile(File expected) {
        java.util.Objects.requireNonNull(expected, "The file to compare to should not be null");
        Preconditions.checkArgument(expected.isFile(), "Expected file:<'%s'> should be an existing file", expected);
    }

    private boolean isAbsolutePath(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        return actual.isAbsolute();
    }
}

