/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Streams;

public class StandardComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardComparisonStrategy INSTANCE = new StandardComparisonStrategy();

    public static StandardComparisonStrategy instance() {
        return INSTANCE;
    }

    protected StandardComparisonStrategy() {
    }

    @Override
    protected Set<Object> newSetUsingComparisonStrategy() {
        return new TreeSet<Object>((o1, o2) -> {
            if (this.areEqual(o1, o2)) {
                return 0;
            }
            return Objects.hashCodeFor(o1) < Objects.hashCodeFor(o2) ? -1 : 1;
        });
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        Class<?> otherClass;
        if (actual == null) {
            return other == null;
        }
        Class<?> actualClass = actual.getClass();
        if (actualClass.isArray() && other != null && (otherClass = other.getClass()).isArray()) {
            Object[] a2;
            if (actualClass.getComponentType().isPrimitive() && otherClass.getComponentType().isPrimitive()) {
                if (actual instanceof byte[]) {
                    a2 = (byte[])actual;
                    if (other instanceof byte[]) {
                        byte[] o2 = (byte[])other;
                        return Arrays.equals((byte[])a2, o2);
                    }
                }
                if (actual instanceof short[]) {
                    a2 = (short[])actual;
                    if (other instanceof short[]) {
                        short[] o3 = (short[])other;
                        return Arrays.equals((short[])a2, o3);
                    }
                }
                if (actual instanceof int[]) {
                    a2 = (int[])actual;
                    if (other instanceof int[]) {
                        int[] o4 = (int[])other;
                        return Arrays.equals((int[])a2, o4);
                    }
                }
                if (actual instanceof long[]) {
                    a2 = (long[])actual;
                    if (other instanceof long[]) {
                        long[] o5 = (long[])other;
                        return Arrays.equals((long[])a2, o5);
                    }
                }
                if (actual instanceof char[]) {
                    a2 = (char[])actual;
                    if (other instanceof char[]) {
                        char[] o6 = (char[])other;
                        return Arrays.equals((char[])a2, o6);
                    }
                }
                if (actual instanceof float[]) {
                    a2 = (float[])actual;
                    if (other instanceof float[]) {
                        float[] o7 = (float[])other;
                        return Arrays.equals((float[])a2, o7);
                    }
                }
                if (actual instanceof double[]) {
                    a2 = (double[])actual;
                    if (other instanceof double[]) {
                        double[] o8 = (double[])other;
                        return Arrays.equals((double[])a2, o8);
                    }
                }
                if (actual instanceof boolean[]) {
                    a2 = (boolean[])actual;
                    if (other instanceof boolean[]) {
                        boolean[] o9 = (boolean[])other;
                        return Arrays.equals((boolean[])a2, o9);
                    }
                }
            }
            if (actual instanceof Object[]) {
                a2 = (Object[])actual;
                if (other instanceof Object[]) {
                    Object[] o10 = (Object[])other;
                    return Arrays.deepEquals(a2, o10);
                }
            }
        }
        return actual.equals(other);
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return false;
        }
        return Streams.stream(iterable).anyMatch(object -> this.areEqual(object, value));
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            collection.removeIf(o2 -> this.areEqual(o2, value));
        } else {
            Iterator<?> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                if (!this.areEqual(iterator2.next(), value)) continue;
                iterator2.remove();
            }
        }
    }

    @Override
    public void iterablesRemoveFirst(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            if (!this.areEqual(iterator2.next(), value)) continue;
            iterator2.remove();
            return;
        }
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    public boolean stringStartsWith(String string2, String prefix) {
        return string2.startsWith(prefix);
    }

    @Override
    public boolean stringEndsWith(String string2, String suffix) {
        return string2.endsWith(suffix);
    }

    @Override
    public boolean stringContains(String string2, String sequence2) {
        return string2.contains(sequence2);
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        if (actual instanceof Comparable) {
            Comparable comparable = (Comparable)actual;
            return comparable.compareTo(other) > 0;
        }
        throw new IllegalArgumentException("argument '%s' should be Comparable but is not".formatted(actual));
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        if (actual instanceof Comparable) {
            Comparable comparable = (Comparable)actual;
            return comparable.compareTo(other) < 0;
        }
        throw new IllegalArgumentException("argument '%s' should be Comparable but is not".formatted(actual));
    }

    @Override
    public boolean isStandard() {
        return true;
    }
}

