/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.Formatter;
import org.assertj.core.presentation.StandardRepresentation;

public class UnicodeRepresentation
extends StandardRepresentation {
    public static final UnicodeRepresentation UNICODE_REPRESENTATION = new UnicodeRepresentation();

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return this.toStringOf(string2);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return this.toStringOf(character);
        }
        return super.toStringOf(object);
    }

    @Override
    protected String toStringOf(Character string2) {
        return UnicodeRepresentation.escapeUnicode(string2.toString());
    }

    @Override
    protected String toStringOf(CharSequence string2) {
        return UnicodeRepresentation.escapeUnicode(string2);
    }

    @Override
    protected String toStringOf(String string2) {
        return UnicodeRepresentation.escapeUnicode(string2);
    }

    private static String escapeUnicode(CharSequence input2) {
        StringBuilder b2 = new StringBuilder(input2.length());
        Formatter formatter2 = new Formatter(b2);
        for (int i2 = 0; i2 < input2.length(); ++i2) {
            char c2 = input2.charAt(i2);
            if (c2 < '\u0080') {
                b2.append(c2);
                continue;
            }
            formatter2.format("\\u%04x", c2);
        }
        formatter2.close();
        return b2.toString();
    }
}

