/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Closeables {
    private static final Logger logger = Logger.getLogger(Closeables.class.getCanonicalName());

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable c2 : closeables) {
            Closeables.closeCloseable(c2);
        }
    }

    private static void closeCloseable(Closeable c2) {
        if (c2 == null) {
            return;
        }
        try {
            c2.close();
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Error occurred while closing " + String.valueOf(c2), t2);
        }
    }

    private Closeables() {
    }
}

