/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CaseFormatUtils {
    private static final String WORD_SEPARATOR_REGEX = "[ _-]";

    private CaseFormatUtils() {
    }

    public static String toCamelCase(String s2) {
        List<String> words = CaseFormatUtils.extractWords(Objects.requireNonNull(s2));
        return IntStream.range(0, words.size()).mapToObj(i2 -> CaseFormatUtils.adjustWordCase((String)words.get(i2), i2 > 0)).collect(Collectors.joining());
    }

    private static List<String> extractWords(String s2) {
        String[] chunks = s2.split(WORD_SEPARATOR_REGEX);
        return Arrays.stream(chunks).map(String::trim).filter(w2 -> !w2.isEmpty()).collect(Collectors.toList());
    }

    private static String adjustWordCase(String s2, boolean firstLetterUpperCased) {
        String firstLetter = s2.substring(0, 1);
        String trailingLetters = s2.substring(1);
        return (firstLetterUpperCased ? firstLetter.toUpperCase() : firstLetter.toLowerCase()) + (CaseFormatUtils.isAllCaps(s2) ? trailingLetters.toLowerCase() : trailingLetters);
    }

    private static boolean isAllCaps(String s2) {
        return s2.toUpperCase().equals(s2);
    }
}

