/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.jetbrains.cef.JCefAppConfig;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.GLBuffers;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefDropTargetListener;
import org.cef.browser.CefPaintEvent;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;

class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler {
    private CefRenderer renderer_;
    private GLCanvas canvas_;
    private long window_handle_ = 0L;
    private boolean justCreated_ = false;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private Point screenPoint_ = new Point(0, 0);
    private double scaleFactor_ = 1.0;
    private int depth = 32;
    private int depth_per_component = 8;
    private boolean isTransparent_;
    private CopyOnWriteArrayList<Consumer<CefPaintEvent>> onPaintListeners = new CopyOnWriteArrayList();

    CefBrowserOsr(CefClient client2, String url, boolean transparent, CefRequestContext context, CefBrowserSettings settings2) {
        this(client2, url, transparent, context, null, null, settings2);
    }

    private CefBrowserOsr(CefClient client2, String url, boolean transparent, CefRequestContext context, CefBrowserOsr parent, Point inspectAt, CefBrowserSettings settings2) {
        super(client2, url, context, parent, inspectAt, settings2);
        this.isTransparent_ = transparent;
        this.renderer_ = new CefRenderer(transparent);
        this.createGLCanvas();
    }

    @Override
    public void createImmediately() {
        this.justCreated_ = true;
        this.createBrowserIfRequired(false);
    }

    @Override
    public Component getUIComponent() {
        return this.canvas_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefBrowser createDevToolsBrowser(CefClient client2, String url, CefRequestContext context, CefBrowser parent, Point inspectAt) {
        return new CefBrowserOsr(client2, url, this.isTransparent_, context, this, inspectAt, null);
    }

    private synchronized long getWindowHandle() {
        NativeSurface surface;
        if (this.window_handle_ == 0L && (surface = this.canvas_.getNativeSurface()) != null) {
            surface.lockSurface();
            this.window_handle_ = this.getWindowHandle(surface.getSurfaceHandle());
            surface.unlockSurface();
            if (!OS.isMacintosh()) assert (this.window_handle_ != 0L);
        }
        return this.window_handle_;
    }

    private void createGLCanvas() {
        GLProfile glprofile = GLProfile.getMaxFixedFunc((boolean)true);
        GLCapabilities glcapabilities = new GLCapabilities(glprofile);
        this.canvas_ = new GLCanvas((GLCapabilitiesImmutable)glcapabilities){
            private Method scaleFactorAccessor;
            private boolean removed_;
            {
                this.scaleFactorAccessor = null;
                this.removed_ = true;
            }

            public void paint(Graphics g2) {
                block7: {
                    CefBrowserOsr.this.createBrowserIfRequired(true);
                    if (g2 instanceof Graphics2D) {
                        GraphicsConfiguration config = ((Graphics2D)g2).getDeviceConfiguration();
                        CefBrowserOsr.this.depth = config.getColorModel().getPixelSize();
                        CefBrowserOsr.this.depth_per_component = config.getColorModel().getComponentSize()[0];
                        if (OS.isMacintosh() && System.getProperty("java.runtime.version").startsWith("1.8")) {
                            try {
                                Object factor;
                                if (this.scaleFactorAccessor == null) {
                                    this.scaleFactorAccessor = ((Object)((Object)this)).getClass().getClassLoader().loadClass("sun.awt.CGraphicsDevice").getDeclaredMethod("getScaleFactor", new Class[0]);
                                }
                                if ((factor = this.scaleFactorAccessor.invoke((Object)config.getDevice(), new Object[0])) instanceof Integer) {
                                    CefBrowserOsr.this.scaleFactor_ = ((Integer)factor).doubleValue();
                                    break block7;
                                }
                                CefBrowserOsr.this.scaleFactor_ = 1.0;
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exc) {
                                CefBrowserOsr.this.scaleFactor_ = 1.0;
                            }
                        } else {
                            CefBrowserOsr.this.scaleFactor_ = ((Graphics2D)g2).getTransform().getScaleX();
                        }
                    }
                }
                super.paint(g2);
            }

            public void addNotify() {
                super.addNotify();
                if (this.removed_) {
                    CefBrowserOsr.this.notifyAfterParentChanged();
                    this.removed_ = false;
                }
            }

            public void removeNotify() {
                if (!this.removed_) {
                    if (!CefBrowserOsr.this.isClosed()) {
                        CefBrowserOsr.this.notifyAfterParentChanged();
                    }
                    this.removed_ = true;
                }
                super.removeNotify();
            }
        };
        this.canvas_.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable glautodrawable, int x2, int y2, int width, int height) {
                CefBrowserOsr.this.browser_rect_.setBounds(CefBrowserOsr.this.canvas_.getBounds());
                CefBrowserOsr.this.screenPoint_ = CefBrowserOsr.this.canvas_.getLocationOnScreen();
                CefBrowserOsr.this.wasResized(width, height);
            }

            public void init(GLAutoDrawable glautodrawable) {
                CefBrowserOsr.this.renderer_.initialize(glautodrawable.getGL().getGL2());
            }

            public void dispose(GLAutoDrawable glautodrawable) {
                CefBrowserOsr.this.renderer_.cleanup(glautodrawable.getGL().getGL2());
            }

            public void display(GLAutoDrawable glautodrawable) {
                CefBrowserOsr.this.renderer_.render(glautodrawable.getGL().getGL2());
            }
        });
        this.canvas_.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }
        });
        this.canvas_.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }

            @Override
            public void mouseDragged(MouseEvent e2) {
                CefBrowserOsr.this.sendMouseEvent(e2);
            }
        });
        this.canvas_.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e2) {
                CefBrowserOsr.this.sendMouseWheelEvent(e2);
            }
        });
        this.canvas_.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
                CefBrowserOsr.this.sendKeyEvent(e2);
            }

            @Override
            public void keyPressed(KeyEvent e2) {
                CefBrowserOsr.this.sendKeyEvent(e2);
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                CefBrowserOsr.this.sendKeyEvent(e2);
            }
        });
        this.canvas_.setFocusable(true);
        this.canvas_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                CefBrowserOsr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent e2) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserOsr.this.setFocus(true);
            }
        });
        new DropTarget((Component)this.canvas_, new CefDropTargetListener(this));
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        Point screenPoint = new Point(this.screenPoint_);
        screenPoint.translate(viewPoint.x, viewPoint.y);
        return screenPoint;
    }

    @Override
    public double getDeviceScaleFactor(CefBrowser browser) {
        return JCefAppConfig.getDeviceScaleFactor(browser.getUIComponent());
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (!show) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        this.renderer_.onPopupSize(size);
    }

    @Override
    public void addOnPaintListener(Consumer<CefPaintEvent> listener) {
        this.onPaintListeners.add(listener);
    }

    @Override
    public void setOnPaintListener(Consumer<CefPaintEvent> listener) {
        this.onPaintListeners.clear();
        this.onPaintListeners.add(listener);
    }

    @Override
    public void removeOnPaintListener(Consumer<CefPaintEvent> listener) {
        this.onPaintListeners.remove(listener);
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        GLContext context;
        GLContext gLContext = context = this.canvas_ != null ? this.canvas_.getContext() : null;
        if (context == null) {
            return;
        }
        if (context.makeCurrent() == 0) {
            return;
        }
        this.renderer_.onPaint(this.canvas_.getGL().getGL2(), popup, dirtyRects, buffer, width, height);
        context.release();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.display();
            }
        });
        if (!this.onPaintListeners.isEmpty()) {
            CefPaintEvent paintEvent = new CefPaintEvent(browser, popup, dirtyRects, buffer, width, height);
            for (Consumer<CefPaintEvent> l2 : this.onPaintListeners) {
                l2.accept(paintEvent);
            }
        }
    }

    @Override
    public boolean onCursorChange(CefBrowser browser, final int cursorType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.setCursor(new Cursor(cursorType));
            }
        });
        return true;
    }

    private static int getDndAction(int mask) {
        int action = 0;
        if ((mask & 1) == 1) {
            action = 1;
        } else if ((mask & 0x10) == 16) {
            action = 2;
        } else if ((mask & 2) == 2) {
            action = 0x40000000;
        }
        return action;
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x2, int y2) {
        final int action = CefBrowserOsr.getDndAction(mask);
        MouseEvent triggerEvent = new MouseEvent((Component)this.canvas_, 506, 0L, 0, x2, y2, 0, false);
        DragGestureEvent ev = new DragGestureEvent(new SyntheticDragGestureRecognizer((Component)this.canvas_, action, triggerEvent), action, new Point(x2, y2), new ArrayList<MouseEvent>(Arrays.asList(triggerEvent)));
        DragSource.getDefaultDragSource().startDrag(ev, null, new StringSelection(dragData.getFragmentText()), new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                CefBrowserOsr.this.dragSourceEndedAt(dsde.getLocation(), action);
                CefBrowserOsr.this.dragSourceSystemDragEnded();
            }
        });
        return true;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    private void createBrowserIfRequired(boolean hasParent) {
        long windowHandle = 0L;
        if (hasParent) {
            windowHandle = this.getWindowHandle();
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), windowHandle, true, this.isTransparent_, null, this.getInspectAt());
            } else {
                this.createBrowser(this.getClient(), windowHandle, this.getUrl(), true, this.isTransparent_, null);
            }
        } else if (hasParent && this.justCreated_) {
            this.notifyAfterParentChanged();
            this.setFocus(true);
            this.justCreated_ = false;
        }
    }

    private void notifyAfterParentChanged() {
        this.getClient().onAfterParentChanged(this);
    }

    @Override
    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        screenInfo.Set(this.scaleFactor_, this.depth, this.depth_per_component, false, this.browser_rect_.getBounds(), this.browser_rect_.getBounds());
        return true;
    }

    @Override
    public CompletableFuture<BufferedImage> createScreenshot(final boolean nativeResolution) {
        final int width = (int)Math.ceil((double)this.canvas_.getWidth() * this.scaleFactor_);
        final int height = (int)Math.ceil((double)this.canvas_.getHeight() * this.scaleFactor_);
        final GL2 gl = this.canvas_.getGL().getGL2();
        final int textureId = this.renderer_.getTextureID();
        final boolean useReadPixels = textureId == 0;
        final Callable<BufferedImage> pixelGrabberCallable = new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() {
                BufferedImage screenshot = new BufferedImage(width, height, 2);
                ByteBuffer buffer = GLBuffers.newDirectByteBuffer((int)(width * height * 4));
                gl.getContext().makeCurrent();
                try {
                    if (useReadPixels) {
                        gl.glReadPixels(0, 0, width, height, 6408, 5121, (Buffer)buffer);
                    } else {
                        gl.glEnable(3553);
                        gl.glBindTexture(3553, textureId);
                        gl.glGetTexImage(3553, 0, 6408, 5121, (Buffer)buffer);
                        gl.glDisable(3553);
                    }
                }
                finally {
                    gl.getContext().release();
                }
                for (int y2 = 0; y2 < height; ++y2) {
                    for (int x2 = 0; x2 < width; ++x2) {
                        int r2 = buffer.get() & 0xFF;
                        int g2 = buffer.get() & 0xFF;
                        int b2 = buffer.get() & 0xFF;
                        int a2 = buffer.get() & 0xFF;
                        int argb = a2 << 24 | r2 << 16 | g2 << 8 | b2 << 0;
                        screenshot.setRGB(x2, useReadPixels ? height - y2 - 1 : y2, argb);
                    }
                }
                if (!nativeResolution && CefBrowserOsr.this.scaleFactor_ != 1.0) {
                    BufferedImage resized = new BufferedImage((int)((double)screenshot.getWidth() / CefBrowserOsr.this.scaleFactor_), (int)((double)screenshot.getHeight() / CefBrowserOsr.this.scaleFactor_), 2);
                    AffineTransform tempTransform = new AffineTransform();
                    tempTransform.scale(1.0 / CefBrowserOsr.this.scaleFactor_, 1.0 / CefBrowserOsr.this.scaleFactor_);
                    AffineTransformOp tempScaleOperation = new AffineTransformOp(tempTransform, 2);
                    resized = tempScaleOperation.filter(screenshot, resized);
                    return resized;
                }
                return screenshot;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                BufferedImage screenshot = (BufferedImage)pixelGrabberCallable.call();
                return CompletableFuture.completedFuture(screenshot);
            }
            catch (Exception e2) {
                CompletableFuture<BufferedImage> future = new CompletableFuture<BufferedImage>();
                future.completeExceptionally(e2);
                return future;
            }
        }
        final CompletableFuture<BufferedImage> future = new CompletableFuture<BufferedImage>(){

            private void safeguardGet() {
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new RuntimeException("Waiting on this Future using the AWT Event Thread is illegal, because it can potentially deadlock the thread.");
                }
            }

            @Override
            public BufferedImage get() throws InterruptedException, ExecutionException {
                this.safeguardGet();
                return (BufferedImage)super.get();
            }

            @Override
            public BufferedImage get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.safeguardGet();
                return (BufferedImage)super.get(timeout2, unit);
            }
        };
        this.canvas_.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable aDrawable, int aArg1, int aArg2, int aArg3, int aArg4) {
            }

            public void init(GLAutoDrawable aDrawable) {
            }

            public void dispose(GLAutoDrawable aDrawable) {
            }

            public void display(GLAutoDrawable aDrawable) {
                CefBrowserOsr.this.canvas_.removeGLEventListener((GLEventListener)this);
                try {
                    future.complete((BufferedImage)pixelGrabberCallable.call());
                }
                catch (Exception e2) {
                    future.completeExceptionally(e2);
                }
            }
        });
        this.canvas_.repaint();
        return future;
    }

    @Override
    public boolean isWindowless() {
        return true;
    }

    private static final class SyntheticDragGestureRecognizer
    extends DragGestureRecognizer {
        public SyntheticDragGestureRecognizer(Component c2, int action, MouseEvent triggerEvent) {
            super(new DragSource(), c2, action);
            this.appendEvent(triggerEvent);
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }
}

