/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.internal;

import java.lang.reflect.Method;

public class ReflectiveTypeFinder {
    private final String methodName;
    private final int expectedNumberOfParameters;
    private final int typedParameter;

    public ReflectiveTypeFinder(String methodName, int expectedNumberOfParameters, int typedParameter) {
        this.methodName = methodName;
        this.expectedNumberOfParameters = expectedNumberOfParameters;
        this.typedParameter = typedParameter;
    }

    public Class<?> findExpectedType(Class<?> fromClass) {
        for (Class<?> c2 = fromClass; c2 != Object.class; c2 = c2.getSuperclass()) {
            for (Method method : c2.getDeclaredMethods()) {
                if (!this.canObtainExpectedTypeFrom(method)) continue;
                return this.expectedTypeFrom(method);
            }
        }
        throw new Error("Cannot determine correct type for " + this.methodName + "() method.");
    }

    private boolean canObtainExpectedTypeFrom(Method method) {
        return method.getName().equals(this.methodName) && method.getParameterTypes().length == this.expectedNumberOfParameters && !method.isSynthetic();
    }

    private Class<?> expectedTypeFrom(Method method) {
        return method.getParameterTypes()[this.typedParameter];
    }
}

