/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HtmlBlockMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "", "Companion", "markdown"})
@SourceDebugExtension(value={"SMAP\nHtmlBlockProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlBlockProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n*L\n1#1,91:1\n107#2,4:92\n107#2,4:96\n*S KotlinDebug\n*F\n+ 1 HtmlBlockProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider\n*L\n38#1:92,4\n44#1:96,4\n*E\n"})
public final class HtmlBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG_NAMES = "address, article, aside, base, basefont, blockquote, body, caption, center, col, colgroup, dd, details, dialog, dir, div, dl, dt, fieldset, figcaption, figure, footer, form, frame, frameset, h1, head, header, hr, html, legend, li, link, main, menu, menuitem, meta, nav, noframes, ol, optgroup, option, p, param, pre, section, source, title, summary, table, tbody, td, tfoot, th, thead, title, tr, track, ul";
    @NotNull
    private static final String TAG_NAME = "[a-zA-Z][a-zA-Z0-9-]*";
    @NotNull
    private static final String ATTR_NAME = "[A-Za-z:_][A-Za-z0-9_.:-]*";
    @NotNull
    private static final String ATTR_VALUE = "\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\")";
    @NotNull
    private static final String ATTRIBUTE = "\\s+" + ATTR_NAME + "(?:" + ATTR_VALUE + ")?";
    @NotNull
    private static final String OPEN_TAG = '<' + TAG_NAME + "(?:" + ATTRIBUTE + ")*\\s*/?>";
    @NotNull
    private static final String CLOSE_TAG = "</" + TAG_NAME + "\\s*>";
    @NotNull
    private static final List<Pair<Regex, Regex>> OPEN_CLOSE_REGEXES;
    @NotNull
    private static final Regex FIND_START_REGEX;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        int matchingGroup = this.matches(pos, stateInfo.getCurrentConstraints());
        if (matchingGroup != -1) {
            return CollectionsKt.listOf((Object)new HtmlBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (Regex)OPEN_CLOSE_REGEXES.get(matchingGroup).getSecond(), pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int n2 = this.matches(pos, constraints);
        return 0 <= n2 ? n2 < 6 : false;
    }

    private final int matches(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return -1;
        }
        CharSequence text = pos.getCurrentLineFromPosition();
        int offset = MarkerBlockProvider.Companion.passSmallIndent$default(MarkerBlockProvider.Companion, text, 0, 2, null);
        if (offset >= text.length() || text.charAt(offset) != '<') {
            return -1;
        }
        CharSequence charSequence = text;
        int n2 = charSequence.length();
        MatchResult matchResult = Regex.find$default((Regex)FIND_START_REGEX, (CharSequence)((Object)charSequence.subSequence(offset, n2)).toString(), (int)0, (int)2, null);
        if (matchResult == null) {
            return -1;
        }
        MatchResult matchResult2 = matchResult;
        Compat compat = Compat.INSTANCE;
        int condition$iv = matchResult2.getGroups().size() == OPEN_CLOSE_REGEXES.size() + 2 ? 1 : 0;
        boolean $i$f$assert = false;
        if (condition$iv == 0) {
            boolean bl2 = false;
            String string2 = "There are some excess capturing groups probably!";
            throw new MarkdownParsingException(string2);
        }
        condition$iv = OPEN_CLOSE_REGEXES.size();
        for (int i2 = 0; i2 < condition$iv; ++i2) {
            if (matchResult2.getGroups().get(i2 + 2) == null) continue;
            return i2;
        }
        Compat i2 = Compat.INSTANCE;
        condition$iv = 0;
        $i$f$assert = false;
        boolean bl3 = false;
        String string3 = "Match found but all groups are empty!";
        throw new MarkdownParsingException(string3);
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)new Regex("<(?:script|pre|style)(?: |>|$)", RegexOption.IGNORE_CASE), (Object)new Regex("</(?:script|style|pre)>", RegexOption.IGNORE_CASE)), new Pair((Object)new Regex("<!--"), (Object)new Regex("-->")), new Pair((Object)new Regex("<\\?"), (Object)new Regex("\\?>")), new Pair((Object)new Regex("<![A-Z]"), (Object)new Regex(">")), new Pair((Object)new Regex("<!\\[CDATA\\["), (Object)new Regex("\\]\\]>")), new Pair((Object)new Regex("</?(?:" + StringsKt.replace$default((String)TAG_NAMES, (String)", ", (String)"|", (boolean)false, (int)4, null) + ")(?: |/?>|$)", RegexOption.IGNORE_CASE), null), new Pair((Object)new Regex("(?:" + OPEN_TAG + '|' + CLOSE_TAG + ")(?: |$)"), null)};
        OPEN_CLOSE_REGEXES = CollectionsKt.listOf((Object[])objectArray);
        FIND_START_REGEX = new Regex("^(" + CollectionsKt.joinToString$default((Iterable)OPEN_CLOSE_REGEXES, (CharSequence)"|", null, null, (int)0, null, (Function1)Companion.FIND_START_REGEX.1.INSTANCE, (int)30, null) + ')');
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R%\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0014\u0010\u001a\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider$Companion;", "", "()V", "ATTRIBUTE", "", "getATTRIBUTE", "()Ljava/lang/String;", "ATTR_NAME", "getATTR_NAME", "ATTR_VALUE", "getATTR_VALUE", "CLOSE_TAG", "getCLOSE_TAG", "FIND_START_REGEX", "Lkotlin/text/Regex;", "getFIND_START_REGEX", "()Lkotlin/text/Regex;", "OPEN_CLOSE_REGEXES", "", "Lkotlin/Pair;", "getOPEN_CLOSE_REGEXES", "()Ljava/util/List;", "OPEN_TAG", "getOPEN_TAG", "TAG_NAME", "getTAG_NAME", "TAG_NAMES", "getTAG_NAMES", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG_NAMES() {
            return TAG_NAMES;
        }

        @NotNull
        public final String getTAG_NAME() {
            return TAG_NAME;
        }

        @NotNull
        public final String getATTR_NAME() {
            return ATTR_NAME;
        }

        @NotNull
        public final String getATTR_VALUE() {
            return ATTR_VALUE;
        }

        @NotNull
        public final String getATTRIBUTE() {
            return ATTRIBUTE;
        }

        @NotNull
        public final String getOPEN_TAG() {
            return OPEN_TAG;
        }

        @NotNull
        public final String getCLOSE_TAG() {
            return CLOSE_TAG;
        }

        @NotNull
        public final List<Pair<Regex, Regex>> getOPEN_CLOSE_REGEXES() {
            return OPEN_CLOSE_REGEXES;
        }

        @NotNull
        public final Regex getFIND_START_REGEX() {
            return FIND_START_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

