/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class LocalNameFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 0) {
            return LocalNameFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (args.size() == 1) {
            return LocalNameFunction.evaluate(args, context.getNavigator());
        }
        throw new FunctionCallException("local-name() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator nav2) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object first2 = list.get(0);
            if (first2 instanceof List) {
                return LocalNameFunction.evaluate((List)first2, nav2);
            }
            if (nav2.isElement(first2)) {
                return nav2.getElementName(first2);
            }
            if (nav2.isAttribute(first2)) {
                return nav2.getAttributeName(first2);
            }
            if (nav2.isProcessingInstruction(first2)) {
                return nav2.getProcessingInstructionTarget(first2);
            }
            if (nav2.isNamespace(first2)) {
                return nav2.getNamespacePrefix(first2);
            }
            if (nav2.isDocument(first2)) {
                return "";
            }
            if (nav2.isComment(first2)) {
                return "";
            }
            if (nav2.isText(first2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the local-name function must be a node-set");
        }
        return "";
    }
}

