/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenRuntimeException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;

public class StringFunction
implements Function {
    private static DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);

    public Object call(Context context, List args) throws FunctionCallException {
        int size = args.size();
        if (size == 0) {
            return StringFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (size == 1) {
            return StringFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string() takes at most argument.");
    }

    public static String evaluate(Object obj, Navigator nav2) {
        try {
            if (nav2 != null && nav2.isText(obj)) {
                return nav2.getTextStringValue(obj);
            }
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.isEmpty()) {
                    return "";
                }
                obj = list.get(0);
            }
            if (nav2 != null) {
                if (nav2.isElement(obj)) {
                    return nav2.getElementStringValue(obj);
                }
                if (nav2.isAttribute(obj)) {
                    return nav2.getAttributeStringValue(obj);
                }
                if (nav2.isDocument(obj)) {
                    Iterator childAxisIterator = nav2.getChildAxisIterator(obj);
                    while (childAxisIterator.hasNext()) {
                        Object descendant = childAxisIterator.next();
                        if (!nav2.isElement(descendant)) continue;
                        return nav2.getElementStringValue(descendant);
                    }
                } else {
                    if (nav2.isProcessingInstruction(obj)) {
                        return nav2.getProcessingInstructionData(obj);
                    }
                    if (nav2.isComment(obj)) {
                        return nav2.getCommentStringValue(obj);
                    }
                    if (nav2.isText(obj)) {
                        return nav2.getTextStringValue(obj);
                    }
                    if (nav2.isNamespace(obj)) {
                        return nav2.getNamespaceStringValue(obj);
                    }
                }
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Boolean) {
                return StringFunction.stringValue((Boolean)obj);
            }
            if (obj instanceof Number) {
                return StringFunction.stringValue(((Number)obj).doubleValue());
            }
        }
        catch (UnsupportedAxisException e2) {
            throw new JaxenRuntimeException(e2);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stringValue(double value) {
        if (value == 0.0) {
            return "0";
        }
        String result2 = null;
        DecimalFormat decimalFormat = format;
        synchronized (decimalFormat) {
            result2 = format.format(value);
        }
        return result2;
    }

    private static String stringValue(boolean value) {
        return value ? "true" : "false";
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
        symbols.setNaN("NaN");
        symbols.setInfinity("Infinity");
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(32);
        format.setDecimalFormatSymbols(symbols);
    }
}

