/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalLayout
implements LayoutManager {
    private int gap = 0;

    public HorizontalLayout() {
    }

    public HorizontalLayout(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public void addLayoutComponent(String name, Component c2) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int height = size.height - insets.top - insets.bottom;
        int width = insets.left;
        int c2 = parent.getComponentCount();
        for (int i2 = 0; i2 < c2; ++i2) {
            Component m2 = parent.getComponent(i2);
            if (!m2.isVisible()) continue;
            m2.setBounds(width, insets.top, m2.getPreferredSize().width, height);
            width += m2.getSize().width + this.gap;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension pref = new Dimension(0, 0);
        int c2 = parent.getComponentCount();
        for (int i2 = 0; i2 < c2; ++i2) {
            Component m2 = parent.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension componentPreferredSize = parent.getComponent(i2).getPreferredSize();
            pref.height = Math.max(pref.height, componentPreferredSize.height);
            pref.width += componentPreferredSize.width + this.gap;
        }
        pref.width += insets.left + insets.right;
        pref.height += insets.top + insets.bottom;
        return pref;
    }

    @Override
    public void removeLayoutComponent(Component c2) {
    }
}

