/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.jdesktop.swingx.BackgroundPaintable;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXPanel
extends JPanel
implements BackgroundPaintable,
Scrollable {
    private ScrollableSizeHint scrollableWidthHint = ScrollableSizeHint.FIT;
    private ScrollableSizeHint scrollableHeightHint = ScrollableSizeHint.FIT;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private boolean inheritAlpha = true;
    private Painter backgroundPainter;
    private PropertyChangeListener painterChangeListener;
    private boolean paintBorderInsets = true;

    public JXPanel() {
    }

    public JXPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JXPanel(LayoutManager layout) {
        super(layout);
    }

    public JXPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            assert (alpha >= 0.0f && (double)alpha <= 1.0);
            float oldAlpha = this.alpha;
            this.alpha = alpha;
            if (alpha > 0.0f && alpha < 1.0f) {
                if (oldAlpha == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                RepaintManager manager = RepaintManager.currentManager(this);
                RepaintManager trm = SwingXUtilities.getTranslucentRepaintManager(manager);
                RepaintManager.setCurrentManager(trm);
            } else if (alpha == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", oldAlpha, alpha);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getEffectiveAlpha() {
        if (this.inheritAlpha) {
            float a2 = this.alpha;
            Container c2 = this;
            while ((c2 = c2.getParent()) != null) {
                if (!(c2 instanceof JXPanel)) continue;
                a2 = Math.min(((JXPanel)c2).getAlpha(), a2);
            }
            return a2;
        }
        return this.alpha;
    }

    public boolean isInheritAlpha() {
        return this.inheritAlpha;
    }

    public void setInheritAlpha(boolean val) {
        if (this.inheritAlpha != val) {
            this.inheritAlpha = val;
            this.firePropertyChange("inheritAlpha", !this.inheritAlpha, this.inheritAlpha);
        }
    }

    public final void setScrollableWidthHint(ScrollableSizeHint hint) {
        if (!hint.isHorizontalCompatible()) {
            throw new IllegalArgumentException("track must be horizontal, but was " + (Object)((Object)hint));
        }
        ScrollableSizeHint oldValue = this.getScrollableWidthHint();
        if (oldValue == hint) {
            return;
        }
        this.scrollableWidthHint = hint;
        this.revalidate();
        this.firePropertyChange("scrollableWidthHint", (Object)oldValue, (Object)this.getScrollableWidthHint());
    }

    public final void setScrollableHeightHint(ScrollableSizeHint hint) {
        if (!hint.isVerticalCompatible()) {
            throw new IllegalArgumentException("track must be vertical, but was " + (Object)((Object)hint));
        }
        ScrollableSizeHint oldValue = this.getScrollableHeightHint();
        if (oldValue == hint) {
            return;
        }
        this.scrollableHeightHint = hint;
        this.revalidate();
        this.firePropertyChange("scrollableHeightHint", (Object)oldValue, (Object)this.getScrollableHeightHint());
    }

    protected ScrollableSizeHint getScrollableWidthHint() {
        return this.scrollableWidthHint;
    }

    protected ScrollableSizeHint getScrollableHeightHint() {
        return this.scrollableHeightHint;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableHeightHint.getTracksParentSize(this);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableWidthHint.getTracksParentSize(this);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        if (orientation == 0) {
            return visibleRect.width;
        }
        throw new IllegalArgumentException("invalid orientation");
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableBlockIncrement(visibleRect, orientation, direction) / 10;
    }

    public void setScrollableTracksViewportHeight(boolean scrollableTracksViewportHeight) {
        this.setScrollableHeightHint(scrollableTracksViewportHeight ? ScrollableSizeHint.FIT : ScrollableSizeHint.NONE);
    }

    public void setScrollableTracksViewportWidth(boolean scrollableTracksViewportWidth) {
        this.setScrollableWidthHint(scrollableTracksViewportWidth ? ScrollableSizeHint.FIT : ScrollableSizeHint.NONE);
    }

    @Override
    public void setBackground(Color bg2) {
        super.setBackground(bg2);
        SwingXUtilities.installBackground(this, bg2);
    }

    @Override
    public void setBackgroundPainter(Painter p2) {
        Painter old = this.getBackgroundPainter();
        if (old instanceof AbstractPainter) {
            ((AbstractPainter)old).removePropertyChangeListener(this.painterChangeListener);
        }
        this.backgroundPainter = p2;
        if (this.backgroundPainter instanceof AbstractPainter) {
            ((AbstractPainter)this.backgroundPainter).addPropertyChangeListener(this.getPainterChangeListener());
        }
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    protected PropertyChangeListener getPainterChangeListener() {
        if (this.painterChangeListener == null) {
            this.painterChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JXPanel.this.repaint();
                }
            };
        }
        return this.painterChangeListener;
    }

    @Override
    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Override
    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    @Override
    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        Composite oldComp = g2d.getComposite();
        try {
            float alpha = this.getEffectiveAlpha();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
            g2d.setComposite(alphaComp);
            super.paint(g2d);
        }
        finally {
            g2d.setComposite(oldComp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g2) {
        if (this.backgroundPainter != null) {
            if (this.isOpaque()) {
                super.paintComponent(g2);
            }
            Graphics2D g22 = (Graphics2D)g2.create();
            try {
                SwingXUtilities.paintBackground(this, g22);
            }
            finally {
                g22.dispose();
            }
        } else {
            super.paintComponent(g2);
        }
    }
}

