/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JXRadioGroup<T>
extends JPanel {
    private static final long serialVersionUID = 3257285842266567986L;
    private ButtonGroup buttonGroup;
    private final List<T> values = new ArrayList<T>();
    private ActionSelectionListener actionHandler;
    private List<ActionListener> actionListeners;

    public JXRadioGroup() {
        this.setLayout(new BoxLayout(this, 0));
        this.buttonGroup = new ButtonGroup();
    }

    public JXRadioGroup(T[] radioValues) {
        this();
        for (int i2 = 0; i2 < radioValues.length; ++i2) {
            this.add(radioValues[i2]);
        }
    }

    public static <T> JXRadioGroup<T> create(T[] radioValues) {
        return new JXRadioGroup<T>(radioValues);
    }

    public void setLayoutAxis(int axis) {
        this.setLayout(new BoxLayout(this, axis));
    }

    public void setValues(T[] radioValues) {
        this.clearAll();
        for (int i2 = 0; i2 < radioValues.length; ++i2) {
            this.add(radioValues[i2]);
        }
    }

    private void clearAll() {
        this.values.clear();
        this.buttonGroup = new ButtonGroup();
        this.removeAll();
    }

    public void add(T radioValue) {
        if (this.values.contains(radioValue)) {
            throw new IllegalArgumentException("cannot add the same value twice " + radioValue);
        }
        if (radioValue instanceof AbstractButton) {
            this.values.add(radioValue);
            this.addButton((AbstractButton)radioValue);
        } else {
            this.values.add(radioValue);
            this.addButton(new JRadioButton("" + radioValue));
        }
    }

    private void addButton(AbstractButton button2) {
        this.buttonGroup.add(button2);
        super.add(button2);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionSelectionListener();
        }
        button2.addActionListener(this.actionHandler);
        button2.addItemListener(this.actionHandler);
    }

    public AbstractButton getSelectedButton() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        for (int i2 = 0; i2 < children.length; ++i2) {
            AbstractButton button2 = children[i2];
            if (button2.getModel() != selectedModel) continue;
            return button2;
        }
        return null;
    }

    private AbstractButton[] getButtonComponents() {
        Component[] children = this.getComponents();
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        for (int i2 = 0; i2 < children.length; ++i2) {
            if (!(children[i2] instanceof AbstractButton)) continue;
            buttons.add((AbstractButton)children[i2]);
        }
        return buttons.toArray(new AbstractButton[buttons.size()]);
    }

    private int getSelectedIndex() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        for (int i2 = 0; i2 < children.length; ++i2) {
            AbstractButton button2 = children[i2];
            if (button2.getModel() != selectedModel) continue;
            return i2;
        }
        return -1;
    }

    public T getSelectedValue() {
        int index = this.getSelectedIndex();
        return index < 0 || index >= this.values.size() ? null : (T)this.values.get(index);
    }

    public void setSelectedValue(T value) {
        int index = this.values.indexOf(value);
        AbstractButton button2 = this.getButtonComponents()[index];
        button2.setSelected(true);
    }

    public AbstractButton getChildButton(int index) {
        return this.getButtonComponents()[index];
    }

    public AbstractButton getChildButton(T value) {
        int index = this.values.indexOf(value);
        return this.getButtonComponents()[index];
    }

    public int getChildButtonCount() {
        return this.getButtonComponents().length;
    }

    public void addActionListener(ActionListener l2) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(l2);
    }

    public void removeActionListener(ActionListener l2) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(l2);
        }
    }

    public ActionListener[] getActionListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    protected void fireActionEvent(ActionEvent e2) {
        if (this.actionListeners != null) {
            for (int i2 = 0; i2 < this.actionListeners.size(); ++i2) {
                ActionListener l2 = this.actionListeners.get(i2);
                l2.actionPerformed(e2);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration<AbstractButton> en = this.buttonGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton button2 = en.nextElement();
            if (enabled && button2.getAction() != null && !button2.getAction().isEnabled()) continue;
            button2.setEnabled(enabled);
        }
    }

    private class ActionSelectionListener
    implements ActionListener,
    ItemListener {
        private ActionSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JXRadioGroup.this.fireActionEvent(e2);
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            JXRadioGroup.this.fireActionEvent(null);
        }
    }
}

