/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.BackgroundPaintable;
import org.jdesktop.swingx.BackgroundPainter;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.PainterUIResource;

public final class SwingXUtilities {
    private static String STYLESHEET = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }";

    private SwingXUtilities() {
    }

    public static void updateMnemonicBinding(JComponent c2, String pressed) {
        SwingXUtilities.updateMnemonicBinding(c2, pressed, null);
    }

    public static void updateMnemonicBinding(JComponent c2, String pressed, String released) {
        Class<?> clazz = c2.getClass();
        int m2 = -1;
        try {
            Method mtd = clazz.getMethod("getMnemonic", new Class[0]);
            m2 = (Integer)mtd.invoke((Object)c2, new Object[0]);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IllegalArgumentException("unable to access mnemonic", e3);
        }
        InputMap map2 = SwingUtilities.getUIInputMap(c2, 2);
        if (m2 != 0) {
            if (map2 == null) {
                map2 = new ComponentInputMapUIResource(c2);
                SwingUtilities.replaceUIInputMap(c2, 2, map2);
            }
            map2.clear();
            map2.put(KeyStroke.getKeyStroke(m2, 8, false), pressed);
            map2.put(KeyStroke.getKeyStroke(m2, 8, true), released);
            map2.put(KeyStroke.getKeyStroke(m2, 0, true), released);
        } else if (map2 != null) {
            map2.clear();
        }
    }

    static <C extends JComponent> void installBackground(C comp, Color color) {
        if (SwingXUtilities.isUIInstallable(color)) {
            if (((BackgroundPaintable)((Object)comp)).getBackgroundPainter() instanceof UIResource) {
                ((BackgroundPaintable)((Object)comp)).setBackgroundPainter(new PainterUIResource<JComponent>(new BackgroundPainter(color)));
            }
        } else {
            ((BackgroundPaintable)((Object)comp)).setBackgroundPainter(new BackgroundPainter(color));
        }
    }

    static <C extends JComponent> void paintBackground(C comp, Graphics2D g2) {
        Painter painter = ((BackgroundPaintable)((Object)comp)).getBackgroundPainter();
        if (painter instanceof BackgroundPainter) {
            painter.paint(g2, comp, comp.getWidth(), comp.getHeight());
        } else if (painter != null) {
            if (((BackgroundPaintable)((Object)comp)).isPaintBorderInsets()) {
                painter.paint(g2, comp, comp.getWidth(), comp.getHeight());
            } else {
                Insets insets = comp.getInsets();
                g2.translate(insets.left, insets.top);
                painter.paint(g2, comp, comp.getWidth() - insets.left - insets.right, comp.getHeight() - insets.top - insets.bottom);
                g2.translate(-insets.left, -insets.top);
            }
        }
    }

    private static Component[] getChildren(Component c2) {
        Component[] children = null;
        if (c2 instanceof MenuElement) {
            MenuElement[] elements = ((MenuElement)((Object)c2)).getSubElements();
            children = new Component[elements.length];
            for (int i2 = 0; i2 < elements.length; ++i2) {
                children[i2] = elements[i2].getComponent();
            }
        } else if (c2 instanceof Container) {
            children = ((Container)c2).getComponents();
        }
        return children;
    }

    public static void setComponentTreeEnabled(Component c2, boolean enabled) {
        c2.setEnabled(enabled);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeEnabled(children[i2], enabled);
            }
        }
    }

    public static void setComponentTreeLocale(Component c2, Locale locale) {
        c2.setLocale(locale);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeLocale(children[i2], locale);
            }
        }
    }

    public static void setComponentTreeBackground(Component c2, Color color) {
        c2.setBackground(color);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeBackground(children[i2], color);
            }
        }
    }

    public static void setComponentTreeForeground(Component c2, Color color) {
        c2.setForeground(color);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeForeground(children[i2], color);
            }
        }
    }

    public static void setComponentTreeFont(Component c2, Font font) {
        c2.setFont(font);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeFont(children[i2], font);
            }
        }
    }

    public static void setHtmlFont(HTMLDocument doc, Font font) {
        String stylesheet = String.format(STYLESHEET, font.getName(), font.getSize(), font.getName(), font.getSize());
        try {
            doc.getStyleSheet().loadRules(new StringReader(stylesheet), null);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static void updateAllComponentTreeUIs() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public static void updateAllComponentTreeUIs(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        for (Window owned : window.getOwnedWindows()) {
            SwingXUtilities.updateAllComponentTreeUIs(owned);
        }
    }

    public static <T> T getAncestor(Class<T> clazz, Component c2) {
        if (clazz == null || c2 == null) {
            return null;
        }
        Container parent = c2.getParent();
        while (parent != null && !clazz.isInstance(parent)) {
            parent = parent instanceof JPopupMenu ? ((JPopupMenu)parent).getInvoker() : parent.getParent();
        }
        return (T)parent;
    }

    public static boolean isDescendingFrom(Component focusOwner, Component parent) {
        while (focusOwner != null) {
            if (focusOwner instanceof JPopupMenu && (focusOwner = ((JPopupMenu)focusOwner).getInvoker()) == null) {
                return false;
            }
            if (focusOwner == parent) {
                return true;
            }
            focusOwner = focusOwner.getParent();
        }
        return false;
    }

    static RepaintManager getTranslucentRepaintManager(RepaintManager delegate) {
        RepaintManager manager = delegate;
        while (manager != null && !manager.getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
            if (manager instanceof ForwardingRepaintManager) {
                manager = ((ForwardingRepaintManager)manager).getDelegateManager();
                continue;
            }
            manager = null;
        }
        return manager == null ? new RepaintManagerX(delegate) : delegate;
    }

    public static boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel selectionModel, int lead, int anchor) {
        if (anchor == -1) {
            anchor = lead;
        }
        if (lead == -1) {
            selectionModel.setAnchorSelectionIndex(-1);
            selectionModel.setLeadSelectionIndex(-1);
        } else {
            if (selectionModel.isSelectedIndex(lead)) {
                selectionModel.addSelectionInterval(lead, lead);
            } else {
                selectionModel.removeSelectionInterval(lead, lead);
            }
            selectionModel.setAnchorSelectionIndex(anchor);
        }
    }

    public static boolean shouldIgnore(MouseEvent mouseEvent, JComponent component) {
        return component == null || !component.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed();
    }

    public static int loc2IndexFileList(JList list, Point point) {
        Object localObject;
        int i2 = list.locationToIndex(point);
        if (i2 != -1 && (localObject = list.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)localObject).booleanValue() && !SwingXUtilities.pointIsInActualBounds(list, i2, point)) {
            i2 = -1;
        }
        return i2;
    }

    private static boolean pointIsInActualBounds(JList list, int index, Point point) {
        ListCellRenderer renderer = list.getCellRenderer();
        ListModel model = list.getModel();
        Object element = model.getElementAt(index);
        Component comp = renderer.getListCellRendererComponent(list, element, index, false, false);
        Dimension prefSize = comp.getPreferredSize();
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (!comp.getComponentOrientation().isLeftToRight()) {
            cellBounds.x += cellBounds.width - prefSize.width;
        }
        cellBounds.width = prefSize.width;
        return cellBounds.contains(point);
    }

    public static void adjustFocus(JComponent component) {
        if (!component.hasFocus() && component.isRequestFocusEnabled()) {
            component.requestFocus();
        }
    }

    public static int convertModifiersToDropAction(int modifiers, int sourcActions) {
        int i2 = 0;
        switch (modifiers & 0xC0) {
            case 192: {
                i2 = 0x40000000;
                break;
            }
            case 128: {
                i2 = 1;
                break;
            }
            case 64: {
                i2 = 2;
                break;
            }
            default: {
                if ((sourcActions & 2) != 0) {
                    i2 = 2;
                    break;
                }
                if ((sourcActions & 1) != 0) {
                    i2 = 1;
                    break;
                }
                if ((sourcActions & 0x40000000) == 0) break;
                i2 = 0x40000000;
            }
        }
        return i2 & sourcActions;
    }
}

