/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jdesktop.swingx.icon.EmptyIcon;

public class IconBorder
implements Border,
Serializable {
    public static final Icon EMPTY_ICON = new EmptyIcon();
    private int padding;
    private Icon icon;
    private int iconPosition;
    private Rectangle iconBounds = new Rectangle();

    public IconBorder() {
        this(null);
    }

    public IconBorder(Icon validIcon) {
        this(validIcon, 11);
    }

    public IconBorder(Icon validIcon, int iconPosition) {
        this(validIcon, iconPosition, 4);
    }

    public IconBorder(Icon validIcon, int iconPosition, int padding) {
        this.setIcon(validIcon);
        this.setPadding(padding);
        this.setIconPosition(iconPosition);
    }

    private boolean isValidPosition(int position) {
        boolean result2 = false;
        switch (position) {
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                result2 = true;
                break;
            }
            default: {
                result2 = false;
            }
        }
        return result2;
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        int horizontalInset = this.icon.getIconWidth() + 2 * this.padding;
        int iconPosition = this.bidiDecodeLeadingTrailing(c2.getComponentOrientation(), this.iconPosition);
        if (iconPosition == 3) {
            return new Insets(0, 0, 0, horizontalInset);
        }
        return new Insets(0, horizontalInset, 0, 0);
    }

    public void setIcon(Icon validIcon) {
        this.icon = validIcon == null ? EMPTY_ICON : validIcon;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        int iconPosition = this.bidiDecodeLeadingTrailing(c2.getComponentOrientation(), this.iconPosition);
        if (iconPosition == 2) {
            this.iconBounds.y = y2 + this.padding;
            this.iconBounds.x = x2 + width - this.padding - this.icon.getIconWidth();
        } else if (iconPosition == 3) {
            this.iconBounds.y = y2 + (height - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = x2 + width - this.padding - this.icon.getIconWidth();
        } else if (iconPosition == 7) {
            this.iconBounds.y = y2 + (height - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = x2 + this.padding;
        }
        this.iconBounds.width = this.icon.getIconWidth();
        this.iconBounds.height = this.icon.getIconHeight();
        this.icon.paintIcon(c2, g2, this.iconBounds.x, this.iconBounds.y);
    }

    private int bidiDecodeLeadingTrailing(ComponentOrientation c2, int position) {
        if (position == 11) {
            if (!c2.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        if (position == 10) {
            if (c2.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        return position;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding < 0 ? 0 : padding;
    }

    public int getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(int iconPosition) {
        if (!this.isValidPosition(iconPosition)) {
            throw new IllegalArgumentException("Invalid icon position");
        }
        this.iconPosition = iconPosition;
    }
}

