/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import javax.swing.UIManager;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIColorHighlighterAddon;
import org.jdesktop.swingx.plaf.UIDependent;

public final class HighlighterFactory {
    public static final Color BEIGE = new Color(245, 245, 220);
    public static final Color LINE_PRINTER = new Color(204, 204, 255);
    public static final Color CLASSIC_LINE_PRINTER = new Color(204, 255, 204);
    public static final Color FLORAL_WHITE = new Color(255, 250, 240);
    public static final Color QUICKSILVER = new Color(240, 240, 224);
    public static final Color GENERIC_GRAY = new Color(229, 229, 229);
    public static final Color LEDGER = new Color(245, 255, 245);
    public static final Color NOTEPAD = new Color(255, 255, 204);

    public static Highlighter createSimpleStriping() {
        UIColorHighlighter hl = new UIColorHighlighter(HighlightPredicate.ODD);
        return hl;
    }

    public static Highlighter createSimpleStriping(int rowsPerGroup) {
        return new UIColorHighlighter(new HighlightPredicate.RowGroupHighlightPredicate(rowsPerGroup));
    }

    public static Highlighter createSimpleStriping(Color stripeBackground) {
        ColorHighlighter hl = new ColorHighlighter(HighlightPredicate.ODD, stripeBackground, null);
        return hl;
    }

    public static Highlighter createSimpleStriping(Color stripeBackground, int rowsPerGroup) {
        HighlightPredicate.RowGroupHighlightPredicate predicate = new HighlightPredicate.RowGroupHighlightPredicate(rowsPerGroup);
        ColorHighlighter hl = new ColorHighlighter(predicate, stripeBackground, null);
        return hl;
    }

    public static Highlighter createAlternateStriping() {
        ColorHighlighter first2 = new ColorHighlighter(HighlightPredicate.EVEN, Color.WHITE, null);
        UIColorHighlighter hl = new UIColorHighlighter(HighlightPredicate.ODD);
        return new CompoundHighlighter(first2, hl);
    }

    public static Highlighter createAlternateStriping(int rowsPerGroup) {
        HighlightPredicate.RowGroupHighlightPredicate predicate = new HighlightPredicate.RowGroupHighlightPredicate(rowsPerGroup);
        ColorHighlighter first2 = new ColorHighlighter(new HighlightPredicate.NotHighlightPredicate(predicate), Color.WHITE, null);
        UIColorHighlighter hl = new UIColorHighlighter(predicate);
        return new CompoundHighlighter(first2, hl);
    }

    public static Highlighter createAlternateStriping(Color baseBackground, Color alternateBackground) {
        ColorHighlighter base2 = new ColorHighlighter(HighlightPredicate.EVEN, baseBackground, null);
        ColorHighlighter alternate = new ColorHighlighter(HighlightPredicate.ODD, alternateBackground, null);
        return new CompoundHighlighter(base2, alternate);
    }

    public static Highlighter createAlternateStriping(Color baseBackground, Color alternateBackground, int linesPerStripe) {
        HighlightPredicate.RowGroupHighlightPredicate predicate = new HighlightPredicate.RowGroupHighlightPredicate(linesPerStripe);
        ColorHighlighter base2 = new ColorHighlighter(new HighlightPredicate.NotHighlightPredicate(predicate), baseBackground, null);
        ColorHighlighter alternate = new ColorHighlighter(predicate, alternateBackground, null);
        return new CompoundHighlighter(base2, alternate);
    }

    public static class UIColorHighlighter
    extends ColorHighlighter
    implements UIDependent {
        public UIColorHighlighter() {
            this(null);
        }

        public UIColorHighlighter(HighlightPredicate odd) {
            super(odd, null, null);
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.setBackground(this.getUIColor());
        }

        private Color getUIColor() {
            Color color = null;
            if (color == null) {
                color = UIManager.getColor("UIColorHighlighter.stripingBackground");
            }
            if (color == null) {
                color = GENERIC_GRAY;
            }
            return color;
        }

        static {
            LookAndFeelAddons.contribute(new UIColorHighlighterAddon());
        }
    }
}

