/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.multislider;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

public abstract class AbstractMultiThumbModel<E>
implements MultiThumbModel<E> {
    protected float maximumValue = 1.0f;
    protected float minimumValue = 0.0f;
    protected List<ThumbDataListener> thumbDataListeners = new ArrayList<ThumbDataListener>();

    @Override
    public float getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public float getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public void setMaximumValue(float maximumValue) {
        this.maximumValue = maximumValue;
    }

    @Override
    public void setMinimumValue(float minimumValue) {
        this.minimumValue = minimumValue;
    }

    @Override
    public void addThumbDataListener(ThumbDataListener listener) {
        this.thumbDataListeners.add(listener);
    }

    @Override
    public void removeThumbDataListener(ThumbDataListener listener) {
        this.thumbDataListeners.remove(listener);
    }

    @Override
    public void thumbPositionChanged(Thumb<E> thumb) {
        this.fireThumbPositionChanged(thumb);
    }

    protected void fireThumbPositionChanged(Thumb<E> thumb) {
        if (this.getThumbIndex(thumb) >= 0) {
            ThumbDataEvent evt = new ThumbDataEvent(this, -1, this.getThumbIndex(thumb), thumb);
            for (ThumbDataListener l2 : this.thumbDataListeners) {
                l2.positionChanged(evt);
            }
        }
    }

    @Override
    public void thumbValueChanged(Thumb<E> thumb) {
        this.fireThumbValueChanged(thumb);
    }

    protected void fireThumbValueChanged(Thumb<E> thumb) {
        ThumbDataEvent evt = new ThumbDataEvent(this, -1, this.getThumbIndex(thumb), thumb);
        for (ThumbDataListener l2 : this.thumbDataListeners) {
            l2.valueChanged(evt);
        }
    }
}

