/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.painter.AbstractAreaPainter;

public class CapsulePainter
extends AbstractAreaPainter<Object> {
    private Portion portion;

    public CapsulePainter() {
        this.setPortion(Portion.Full);
    }

    public CapsulePainter(Portion portion) {
        this.setPortion(portion);
    }

    public Portion getPortion() {
        return this.portion;
    }

    public void setPortion(Portion portion) {
        Portion old = this.portion;
        this.portion = portion;
        this.setDirty(true);
        this.firePropertyChange("portion", (Object)old, (Object)this.getPortion());
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        Shape rect = this.provideShape(g2, component, width, height);
        if (this.getStyle() == AbstractAreaPainter.Style.BOTH || this.getStyle() == AbstractAreaPainter.Style.FILLED) {
            g2.setPaint(this.getFillPaint());
            g2.fill(rect);
        }
        if (this.getStyle() == AbstractAreaPainter.Style.BOTH || this.getStyle() == AbstractAreaPainter.Style.OUTLINE) {
            g2.setPaint(this.getBorderPaint());
            g2.draw(rect);
        }
    }

    @Override
    protected Shape provideShape(Graphics2D g2, Object comp, int width, int height) {
        int round = 10;
        int rheight = height;
        int ry = 0;
        if (this.getPortion() == Portion.Top) {
            round = height * 2;
            rheight = height * 2;
        }
        if (this.getPortion() == Portion.Bottom) {
            round = height * 2;
            rheight = height * 2;
            ry = -height;
        }
        return new RoundRectangle2D.Double(0.0, ry, width, rheight, round, round);
    }

    public static enum Portion {
        Top,
        Full,
        Bottom,
        Left,
        Right;

    }
}

