/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.effects;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class AbstractAreaEffect
implements AreaEffect {
    private static final boolean debug = false;
    BufferedImage _clipImage = null;
    private Color brushColor;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int brushSteps;
    private int effectWidth;
    private boolean renderInsideShape;
    private Point2D offset;
    private boolean shouldFillShape;
    private boolean shapeMasked;

    public AbstractAreaEffect() {
        this.setBrushColor(Color.BLACK);
        this.setBrushSteps(10);
        this.setEffectWidth(8);
        this.setRenderInsideShape(false);
        this.setOffset(new Point(4, 4));
        this.setShouldFillShape(true);
        this.setShapeMasked(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Graphics2D g2, Shape clipShape, int width, int height) {
        width = (int)(clipShape.getBounds2D().getWidth() + clipShape.getBounds2D().getX());
        height = (int)(clipShape.getBounds2D().getHeight() + clipShape.getBounds2D().getY());
        Rectangle effectBounds = new Rectangle(0, 0, width + this.getEffectWidth() * 2 + 1, height + this.getEffectWidth() * 2 + 1);
        if (this.isShapeMasked()) {
            BufferedImage clipImage = this.getClipImage(effectBounds);
            Graphics2D g22 = clipImage.createGraphics();
            try {
                g22.setPaint(Color.BLACK);
                g22.setComposite(AlphaComposite.Clear);
                g22.fillRect(0, 0, effectBounds.width, effectBounds.height);
                g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g22.translate((double)this.getEffectWidth() - this.getOffset().getX(), (double)this.getEffectWidth() - this.getOffset().getY());
                this.paintBorderGlow(g22, clipShape, width, height);
                g22.setComposite(AlphaComposite.Clear);
                g22.setColor(Color.WHITE);
                if (this.isRenderInsideShape()) {
                    Area area2 = new Area(effectBounds);
                    area2.subtract(new Area(clipShape));
                    g22.fill(area2);
                } else {
                    g22.fill(clipShape);
                }
            }
            finally {
                g22.dispose();
            }
            g2.drawImage((Image)clipImage, -this.getEffectWidth() + (int)this.getOffset().getX(), -this.getEffectWidth() + (int)this.getOffset().getY(), null);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintBorderGlow(g2, clipShape, width, height);
        }
    }

    private BufferedImage getClipImage(Rectangle effectBounds) {
        if (this._clipImage == null || this._clipImage.getWidth() != effectBounds.width || this._clipImage.getHeight() != effectBounds.height) {
            this._clipImage = new BufferedImage(effectBounds.width, effectBounds.height, 2);
        }
        this._clipImage.getGraphics().clearRect(0, 0, this._clipImage.getWidth(), this._clipImage.getHeight());
        return this._clipImage;
    }

    protected void paintBorderGlow(Graphics2D g2, Shape clipShape, int width, int height) {
        int steps = this.getBrushSteps();
        float brushAlpha = 1.0f / (float)steps;
        boolean inside = this.isRenderInsideShape();
        g2.setPaint(this.getBrushColor());
        g2.translate(this.offset.getX(), this.offset.getY());
        if (this.isShouldFillShape()) {
            if (inside) {
                g2.setComposite(AlphaComposite.getInstance(10, 1.0f));
                Area a1 = new Area(new Rectangle((int)(-this.offset.getX()) - 20, (int)(-this.offset.getY()) - 20, width + 40, height + 40));
                Area a2 = new Area(clipShape);
                a1.subtract(a2);
                g2.fill(a1);
            } else {
                g2.setComposite(AlphaComposite.getInstance(4, 1.0f));
                g2.fill(clipShape);
            }
        }
        g2.setComposite(AlphaComposite.getInstance(4, brushAlpha));
        for (float i2 = 0.0f; i2 < (float)steps; i2 += 1.0f) {
            float brushWidth = i2 * (float)this.effectWidth / (float)steps;
            g2.setStroke(new BasicStroke(brushWidth, 1, 1));
            g2.draw(clipShape);
        }
        g2.translate(-this.offset.getX(), -this.offset.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.propertyChangeSupport.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.propertyChangeSupport.removePropertyChangeListener(l2);
    }

    public Color getBrushColor() {
        return this.brushColor;
    }

    public void setBrushColor(Color brushColor) {
        Color oldBrushColor = this.brushColor;
        this.brushColor = brushColor;
        this.propertyChangeSupport.firePropertyChange("brushColor", oldBrushColor, brushColor);
    }

    public int getBrushSteps() {
        return this.brushSteps;
    }

    public void setBrushSteps(int brushSteps) {
        int oldBrushSteps = this.brushSteps;
        this.brushSteps = brushSteps;
        this.propertyChangeSupport.firePropertyChange("brushSteps", new Integer(oldBrushSteps), new Integer(brushSteps));
    }

    public int getEffectWidth() {
        return this.effectWidth;
    }

    public void setEffectWidth(int effectWidth) {
        int oldEffectWidth = this.effectWidth;
        this.effectWidth = effectWidth;
        this.propertyChangeSupport.firePropertyChange("effectWidth", new Integer(oldEffectWidth), new Integer(effectWidth));
    }

    public boolean isRenderInsideShape() {
        return this.renderInsideShape;
    }

    public void setRenderInsideShape(boolean renderInsideShape) {
        boolean oldRenderInsideShape = this.renderInsideShape;
        this.renderInsideShape = renderInsideShape;
        this.propertyChangeSupport.firePropertyChange("renderInsideShape", new Boolean(oldRenderInsideShape), new Boolean(renderInsideShape));
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D offset) {
        Point2D oldOffset = this.offset;
        this.offset = offset;
        this.propertyChangeSupport.firePropertyChange("offset", oldOffset, offset);
    }

    public boolean isShouldFillShape() {
        return this.shouldFillShape;
    }

    public void setShouldFillShape(boolean shouldFillShape) {
        boolean oldShouldFillShape = this.shouldFillShape;
        this.shouldFillShape = shouldFillShape;
        this.propertyChangeSupport.firePropertyChange("shouldFillShape", new Boolean(oldShouldFillShape), new Boolean(shouldFillShape));
    }

    public boolean isShapeMasked() {
        return this.shapeMasked;
    }

    public void setShapeMasked(boolean shapeMasked) {
        boolean oldShapeMasked = this.shapeMasked;
        this.shapeMasked = shapeMasked;
        this.propertyChangeSupport.firePropertyChange("shapeMasked", new Boolean(oldShapeMasked), new Boolean(shapeMasked));
    }
}

