/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.MonthViewUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicCalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.BasicCalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class BasicMonthViewUI
extends MonthViewUI {
    private static final Logger LOG = Logger.getLogger(BasicMonthViewUI.class.getName());
    private static final int CALENDAR_SPACING = 10;
    public static final int MONTH_DOWN = 1;
    public static final int MONTH_UP = 2;
    protected static final int WEEK_HEADER_COLUMN = 0;
    protected static final int DAYS_IN_WEEK = 7;
    protected static final int FIRST_DAY_COLUMN = 1;
    protected static final int LAST_DAY_COLUMN = 7;
    protected static final int DAY_HEADER_ROW = 0;
    protected static final int WEEKS_IN_MONTH = 6;
    protected static final int FIRST_WEEK_ROW = 1;
    protected static final int LAST_WEEK_ROW = 6;
    @Deprecated
    protected String[] monthsOfTheYear;
    protected JXMonthView monthView;
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private Handler handler;
    private Date lastDisplayedDate;
    private boolean usingKeyboard = false;
    private Date pivotDate = null;
    private SortedSet<Date> originalDateSpan;
    protected boolean isLeftToRight;
    protected Icon monthUpImage;
    protected Icon monthDownImage;
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private int fullMonthBoxHeight;
    private int fullBoxWidth;
    private int fullBoxHeight;
    private int calendarWidth;
    private int calendarHeight;
    private int fullCalendarHeight;
    private int fullCalendarWidth;
    private int calendarRowCount = 1;
    private int calendarColumnCount = 1;
    protected Rectangle calendarGrid = new Rectangle();
    private String[] daysOfTheWeek;
    private CalendarRenderingHandler renderingHandler;
    private CellRendererPane rendererPane;
    private CalendarHeaderHandler calendarHeaderHandler;

    public static ComponentUI createUI(JComponent c2) {
        return new BasicMonthViewUI();
    }

    @Override
    public void installUI(JComponent c2) {
        this.monthView = (JXMonthView)c2;
        this.monthView.setLayout(this.createLayoutManager());
        this.installRenderingHandler();
        this.installDefaults();
        this.installDelegate();
        this.installKeyboardActions();
        this.installComponents();
        this.updateLocale(false);
        this.updateZoomable();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c2) {
        this.uninstallRenderingHandler();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.monthView.setLayout(null);
        this.monthView = null;
    }

    protected void installComponents() {
        this.setCalendarHeaderHandler(this.createCalendarHeaderHandler());
        this.getCalendarHeaderHandler().install(this.monthView);
    }

    protected void uninstallComponents() {
        this.getCalendarHeaderHandler().uninstall(this.monthView);
        this.setCalendarHeaderHandler(null);
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.monthView, "opaque", Boolean.TRUE);
        if (SwingXUtilities.isUIInstallable(this.monthView.getBackground())) {
            this.monthView.setBackground(UIManagerExt.getColor("JXMonthView.background"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getForeground())) {
            this.monthView.setForeground(UIManagerExt.getColor("JXMonthView.foreground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getFont())) {
            this.monthView.setFont(UIManager.getFont("JXMonthView.font"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getMonthStringBackground())) {
            this.monthView.setMonthStringBackground(UIManagerExt.getColor("JXMonthView.monthStringBackground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getMonthStringForeground())) {
            this.monthView.setMonthStringForeground(UIManagerExt.getColor("JXMonthView.monthStringForeground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getDaysOfTheWeekForeground())) {
            this.monthView.setDaysOfTheWeekForeground(UIManagerExt.getColor("JXMonthView.daysOfTheWeekForeground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getSelectionBackground())) {
            this.monthView.setSelectionBackground(UIManagerExt.getColor("JXMonthView.selectedBackground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getSelectionForeground())) {
            this.monthView.setSelectionForeground(UIManagerExt.getColor("JXMonthView.selectedForeground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getFlaggedDayForeground())) {
            this.monthView.setFlaggedDayForeground(UIManagerExt.getColor("JXMonthView.flaggedDayForeground"));
        }
        this.monthView.setBoxPaddingX(UIManagerExt.getInt("JXMonthView.boxPaddingX"));
        this.monthView.setBoxPaddingY(UIManagerExt.getInt("JXMonthView.boxPaddingY"));
    }

    protected void installDelegate() {
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.setFirstDisplayedDay(this.monthView.getFirstDisplayedDay());
    }

    @Deprecated
    protected boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        this.installKeyBindings(1);
        ActionMap actionMap = this.monthView.getActionMap();
        KeyboardAction acceptAction = new KeyboardAction(0);
        actionMap.put("acceptSelection", acceptAction);
        KeyboardAction cancelAction = new KeyboardAction(1);
        actionMap.put("cancelSelection", cancelAction);
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("adjustSelectionPreviousDay", new KeyboardAction(6));
        actionMap.put("adjustSelectionNextDay", new KeyboardAction(7));
        actionMap.put("adjustSelectionPreviousWeek", new KeyboardAction(8));
        actionMap.put("adjustSelectionNextWeek", new KeyboardAction(9));
        actionMap.put("monthViewCommit", acceptAction);
        actionMap.put("monthViewCancel", cancelAction);
        AbstractActionExt prev = new AbstractActionExt(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                BasicMonthViewUI.this.previousMonth();
            }
        };
        this.monthView.getActionMap().put("scrollToPreviousMonth", prev);
        AbstractActionExt next2 = new AbstractActionExt(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                BasicMonthViewUI.this.nextMonth();
            }
        };
        this.monthView.getActionMap().put("scrollToNextMonth", next2);
    }

    private void installKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "adjustSelectionPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "adjustSelectionNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "adjustSelectionPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "adjustSelectionNextWeek");
    }

    private void uninstallKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.clear();
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.monthView.addPropertyChangeListener(this.propertyChangeListener);
        this.monthView.addMouseListener(this.mouseListener);
        this.monthView.addMouseMotionListener(this.mouseMotionListener);
        this.monthView.getSelectionModel().addDateSelectionListener(this.getHandler());
    }

    protected void uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.getHandler());
        this.monthView.removeMouseMotionListener(this.mouseMotionListener);
        this.monthView.removeMouseListener(this.mouseListener);
        this.monthView.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseMotionListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
    }

    protected void installRenderingHandler() {
        this.setRenderingHandler(this.createRenderingHandler());
        if (this.getRenderingHandler() != null) {
            this.rendererPane = new CellRendererPane();
            this.monthView.add(this.rendererPane);
        }
    }

    protected void uninstallRenderingHandler() {
        if (this.getRenderingHandler() == null) {
            return;
        }
        this.monthView.remove(this.rendererPane);
        this.rendererPane = null;
        this.setRenderingHandler(null);
    }

    protected CalendarRenderingHandler createRenderingHandler() {
        return new RenderingHandler();
    }

    protected void setRenderingHandler(CalendarRenderingHandler renderingHandler) {
        this.renderingHandler = renderingHandler;
    }

    protected CalendarRenderingHandler getRenderingHandler() {
        return this.renderingHandler;
    }

    protected void updateComponentInputMap() {
        if (this.monthView.isComponentInputMapEnabled()) {
            this.installKeyBindings(2);
        } else {
            this.uninstallKeyBindings(2);
        }
    }

    protected void updateLocale(boolean revalidate) {
        Locale locale = this.monthView.getLocale();
        if (this.getRenderingHandler() != null) {
            this.getRenderingHandler().setLocale(locale);
        }
        this.monthsOfTheYear = DateFormatSymbols.getInstance(locale).getMonths();
        this.daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (this.daysOfTheWeek == null) {
            this.daysOfTheWeek = new String[7];
            String[] dateFormatSymbols = DateFormatSymbols.getInstance(locale).getShortWeekdays();
            this.daysOfTheWeek = new String[7];
            for (int i2 = 1; i2 <= 7; ++i2) {
                this.daysOfTheWeek[i2 - 1] = dateFormatSymbols[i2];
            }
        }
        if (revalidate) {
            this.monthView.invalidate();
            this.monthView.validate();
        }
    }

    @Override
    public String[] getDaysOfTheWeek() {
        String[] days = new String[this.daysOfTheWeek.length];
        System.arraycopy(this.daysOfTheWeek, 0, days, 0, days.length);
        return days;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public boolean isUsingKeyboard() {
        return this.usingKeyboard;
    }

    public void setUsingKeyboard(boolean val) {
        this.usingKeyboard = val;
    }

    protected Rectangle getDayBoundsAtLocation(int x2, int y2) {
        Rectangle monthDetails = this.getMonthDetailsBoundsAtLocation(x2, y2);
        if (monthDetails == null || !monthDetails.contains(x2, y2)) {
            return null;
        }
        int row = (y2 - monthDetails.y) / this.fullBoxHeight;
        int column2 = (x2 - monthDetails.x) / this.fullBoxWidth;
        return new Rectangle(monthDetails.x + column2 * this.fullBoxWidth, monthDetails.y + row * this.fullBoxHeight, this.fullBoxWidth, this.fullBoxHeight);
    }

    protected Rectangle getDayBoundsInMonth(Date month2, int row, int column2) {
        this.checkValidRow(row, column2);
        if (0 == column2 && !this.monthView.isShowingWeekNumber()) {
            return null;
        }
        Rectangle monthBounds = this.getMonthBounds(month2);
        if (monthBounds == null) {
            return null;
        }
        monthBounds.y += this.getMonthHeaderHeight() + (row - 0) * this.fullBoxHeight;
        int absoluteColumn = column2 - 1;
        if (this.monthView.isShowingWeekNumber()) {
            ++absoluteColumn;
        }
        if (this.isLeftToRight) {
            monthBounds.x += absoluteColumn * this.fullBoxWidth;
        } else {
            int leading = monthBounds.x + monthBounds.width - this.fullBoxWidth;
            monthBounds.x = leading - absoluteColumn * this.fullBoxWidth;
        }
        monthBounds.width = this.fullBoxWidth;
        monthBounds.height = this.fullBoxHeight;
        return monthBounds;
    }

    protected Point getDayGridPositionAtLocation(int x2, int y2) {
        Rectangle monthDetailsBounds = this.getMonthDetailsBoundsAtLocation(x2, y2);
        if (monthDetailsBounds == null || !monthDetailsBounds.contains(x2, y2)) {
            return null;
        }
        int calendarRow = (y2 - monthDetailsBounds.y) / this.fullBoxHeight + 0;
        int absoluteColumn = (x2 - monthDetailsBounds.x) / this.fullBoxWidth;
        int calendarColumn = absoluteColumn + 1;
        if (!this.isLeftToRight) {
            int leading = monthDetailsBounds.x + monthDetailsBounds.width;
            calendarColumn = (leading - x2) / this.fullBoxWidth + 1;
        }
        if (this.monthView.isShowingWeekNumber()) {
            --calendarColumn;
        }
        return new Point(calendarColumn, calendarRow);
    }

    protected Date getDayInMonth(Date month2, int row, int column2) {
        if (row == 0 || column2 == 0) {
            return null;
        }
        Calendar calendar = this.getCalendar(month2);
        int monthField = calendar.get(2);
        if (!CalendarUtils.isStartOfMonth(calendar)) {
            throw new IllegalStateException("calendar must be start of month but was: " + month2.getTime());
        }
        CalendarUtils.startOfWeek(calendar);
        calendar.add(5, (row - 1) * 7 + (column2 - 1));
        if (calendar.get(2) == monthField) {
            return calendar.getTime();
        }
        return null;
    }

    protected Point getDayGridPosition(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Calendar calendar = this.getCalendar(date);
        Date startOfDay = CalendarUtils.startOfDay(calendar, date);
        CalendarUtils.startOfWeek(calendar);
        int column2 = 1;
        while (calendar.getTime().before(startOfDay)) {
            ++column2;
            calendar.add(5, 1);
        }
        Date startOfWeek = CalendarUtils.startOfWeek(calendar, date);
        calendar.setTime(date);
        CalendarUtils.startOfMonth(calendar);
        int row = 1;
        while (calendar.getTime().before(startOfWeek)) {
            ++row;
            calendar.add(3, 1);
        }
        return new Point(column2, row);
    }

    @Override
    public Date getDayAtLocation(int x2, int y2) {
        Point dayInGrid = this.getDayGridPositionAtLocation(x2, y2);
        if (dayInGrid == null || dayInGrid.x == 0 || dayInGrid.y == 0) {
            return null;
        }
        Date month2 = this.getMonthAtLocation(x2, y2);
        return this.getDayInMonth(month2, dayInGrid.y, dayInGrid.x);
    }

    protected Rectangle getDayBounds(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Point position = this.getDayGridPosition(date);
        Rectangle monthBounds = this.getMonthBounds(date);
        monthBounds.y += this.getMonthHeaderHeight() + (position.y - 0) * this.fullBoxHeight;
        if (this.monthView.isShowingWeekNumber()) {
            ++position.x;
        }
        --position.x;
        if (this.isLeftToRight) {
            monthBounds.x += position.x * this.fullBoxWidth;
        } else {
            int start = monthBounds.x + monthBounds.width - this.fullBoxWidth;
            monthBounds.x = start - position.x * this.fullBoxWidth;
        }
        monthBounds.width = this.fullBoxWidth;
        monthBounds.height = this.fullBoxHeight;
        return monthBounds;
    }

    private void checkValidRow(int row, int column2) {
        if (column2 < 0 || column2 > 7) {
            throw new IllegalArgumentException("illegal column in day grid " + column2);
        }
        if (row < 0 || row > 6) {
            throw new IllegalArgumentException("illegal row in day grid" + row);
        }
    }

    private boolean isVisible(Date date) {
        return !this.getFirstDisplayedDay().after(date) && !this.getLastDisplayedDay().before(date);
    }

    protected int getTraversableGridPositionAtLocation(int x2, int y2) {
        Rectangle headerBounds = this.getMonthHeaderBoundsAtLocation(x2, y2);
        if (headerBounds == null) {
            return -1;
        }
        if (y2 < headerBounds.y + this.arrowPaddingY) {
            return -1;
        }
        if (y2 > headerBounds.y + headerBounds.height - this.arrowPaddingY) {
            return -1;
        }
        headerBounds.setBounds(headerBounds.x + this.arrowPaddingX, y2, headerBounds.width - 2 * this.arrowPaddingX, headerBounds.height);
        if (!headerBounds.contains(x2, y2)) {
            return -1;
        }
        Rectangle hitArea = new Rectangle(headerBounds.x, headerBounds.y, this.monthUpImage.getIconWidth(), this.monthUpImage.getIconHeight());
        if (hitArea.contains(x2, y2)) {
            return this.isLeftToRight ? 1 : 2;
        }
        hitArea.translate(headerBounds.width - this.monthUpImage.getIconWidth(), 0);
        if (hitArea.contains(x2, y2)) {
            return this.isLeftToRight ? 2 : 1;
        }
        return -1;
    }

    protected Rectangle getMonthHeaderBoundsAtLocation(int x2, int y2) {
        Rectangle header2 = this.getMonthBoundsAtLocation(x2, y2);
        if (header2 == null) {
            return null;
        }
        header2.height = this.getMonthHeaderHeight();
        return header2;
    }

    protected Rectangle getMonthDetailsBoundsAtLocation(int x2, int y2) {
        Rectangle month2 = this.getMonthBoundsAtLocation(x2, y2);
        if (month2 == null) {
            return null;
        }
        int startOfDaysY = month2.y + this.getMonthHeaderHeight();
        if (y2 < startOfDaysY) {
            return null;
        }
        month2.y = startOfDaysY;
        month2.height -= this.getMonthHeaderHeight();
        return month2;
    }

    protected Rectangle getMonthBoundsAtLocation(int x2, int y2) {
        if (!this.calendarGrid.contains(x2, y2)) {
            return null;
        }
        int calendarRow = (y2 - this.calendarGrid.y) / this.fullCalendarHeight;
        int calendarColumn = (x2 - this.calendarGrid.x) / this.fullCalendarWidth;
        return new Rectangle(this.calendarGrid.x + calendarColumn * this.fullCalendarWidth, this.calendarGrid.y + calendarRow * this.fullCalendarHeight, this.calendarWidth, this.calendarHeight);
    }

    protected Point getMonthGridPositionAtLocation(int x2, int y2) {
        if (!this.calendarGrid.contains(x2, y2)) {
            return null;
        }
        int calendarRow = (y2 - this.calendarGrid.y) / this.fullCalendarHeight;
        int calendarColumn = (x2 - this.calendarGrid.x) / this.fullCalendarWidth;
        if (!this.isLeftToRight) {
            int start = this.calendarGrid.x + this.calendarGrid.width;
            calendarColumn = (start - x2) / this.fullCalendarWidth;
        }
        return new Point(calendarColumn, calendarRow);
    }

    protected Date getMonthAtLocation(int x2, int y2) {
        Point month2 = this.getMonthGridPositionAtLocation(x2, y2);
        if (month2 == null) {
            return null;
        }
        return this.getMonth(month2.y, month2.x);
    }

    protected Date getMonth(int row, int column2) {
        Calendar calendar = this.getCalendar();
        calendar.add(2, row * this.calendarColumnCount + column2);
        return calendar.getTime();
    }

    protected Point getMonthGridPosition(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Calendar calendar = this.getCalendar();
        int firstMonth = calendar.get(2);
        int firstYear = calendar.get(1);
        calendar.setTime(date);
        int month2 = calendar.get(2);
        int year2 = calendar.get(1);
        int diffMonths = month2 - firstMonth + (year2 - firstYear) * 12;
        int row = diffMonths / this.calendarColumnCount;
        int column2 = diffMonths % this.calendarColumnCount;
        return new Point(column2, row);
    }

    protected Rectangle getMonthBounds(int row, int column2) {
        int startY = this.calendarGrid.y + row * this.fullCalendarHeight;
        int startX = this.calendarGrid.x + column2 * this.fullCalendarWidth;
        if (!this.isLeftToRight) {
            startX = this.calendarGrid.x + (this.calendarColumnCount - 1 - column2) * this.fullCalendarWidth;
        }
        return new Rectangle(startX, startY, this.calendarWidth, this.calendarHeight);
    }

    protected Rectangle getMonthBounds(Date date) {
        Point position = this.getMonthGridPosition(date);
        return position != null ? this.getMonthBounds(position.y, position.x) : null;
    }

    protected Rectangle getMonthHeaderBounds(Date date, boolean includeInsets) {
        Point position = this.getMonthGridPosition(date);
        if (position == null) {
            return null;
        }
        Rectangle bounds = this.getMonthBounds(position.y, position.x);
        bounds.height = this.getMonthHeaderHeight();
        if (!includeInsets) {
            // empty if block
        }
        return bounds;
    }

    protected Dimension getMonthSize() {
        return new Dimension(this.calendarWidth, this.calendarHeight);
    }

    protected Dimension getDaySize() {
        return new Dimension(this.fullBoxWidth, this.fullBoxHeight);
    }

    protected int getMonthHeaderHeight() {
        return this.fullMonthBoxHeight;
    }

    private void calculateMonthGridLayoutProperties() {
        this.calculateMonthGridRowColumnCount();
        this.calculateMonthGridBounds();
    }

    private void calculateMonthGridBounds() {
        this.calendarGrid.setBounds(this.calculateCalendarGridX(), this.calculateCalendarGridY(), this.calculateCalendarGridWidth(), this.calculateCalendarGridHeight());
    }

    private int calculateCalendarGridY() {
        return (this.monthView.getHeight() - this.calculateCalendarGridHeight()) / 2;
    }

    private int calculateCalendarGridX() {
        return (this.monthView.getWidth() - this.calculateCalendarGridWidth()) / 2;
    }

    private int calculateCalendarGridHeight() {
        return this.calendarHeight * this.calendarRowCount + 10 * (this.calendarRowCount - 1);
    }

    private int calculateCalendarGridWidth() {
        return this.calendarWidth * this.calendarColumnCount + 10 * (this.calendarColumnCount - 1);
    }

    private void calculateMonthGridRowColumnCount() {
        int oldNumCalCols = this.calendarColumnCount;
        int oldNumCalRows = this.calendarRowCount;
        this.calendarRowCount = 1;
        this.calendarColumnCount = 1;
        if (!this.isZoomable()) {
            int addRows;
            int addColumns = (this.monthView.getWidth() - this.calendarWidth) / (this.calendarWidth + 10);
            if (addColumns > 0) {
                this.calendarColumnCount += addColumns;
            }
            if ((addRows = (this.monthView.getHeight() - this.calendarHeight) / (this.calendarHeight + 10)) > 0) {
                this.calendarRowCount += addRows;
            }
        }
        if (oldNumCalCols != this.calendarColumnCount || oldNumCalRows != this.calendarRowCount) {
            this.updateLastDisplayedDay(this.getFirstDisplayedDay());
        }
    }

    protected boolean isZoomable() {
        return this.monthView.isZoomable();
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        this.paintBackground(g2);
        this.paint(g2, c2);
    }

    protected void paintBackground(Graphics g2) {
        if (this.monthView.isOpaque()) {
            g2.setColor(this.monthView.getBackground());
            g2.fillRect(0, 0, this.monthView.getWidth(), this.monthView.getHeight());
        }
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Rectangle clip = g2.getClipBounds();
        Calendar cal = this.getCalendar();
        for (int row = 0; row < this.calendarRowCount; ++row) {
            for (int column2 = 0; column2 < this.calendarColumnCount; ++column2) {
                Rectangle bounds = this.getMonthBounds(row, column2);
                if (bounds.intersects(clip)) {
                    this.paintMonth(g2, cal);
                }
                cal.add(2, 1);
            }
        }
    }

    protected void paintMonth(Graphics g2, Calendar month2) {
        this.paintMonthHeader(g2, month2);
        this.paintDayHeader(g2, month2);
        this.paintWeekHeader(g2, month2);
        this.paintDays(g2, month2);
    }

    protected void paintMonthHeader(Graphics g2, Calendar month2) {
        Rectangle page = this.getMonthHeaderBounds(month2.getTime(), false);
        this.paintDayOfMonth(g2, page, month2, CalendarState.TITLE);
    }

    protected void paintDayHeader(Graphics g2, Calendar month2) {
        this.paintDaysOfWeekSeparator(g2, month2);
        Calendar cal = (Calendar)month2.clone();
        CalendarUtils.startOfWeek(cal);
        for (int i2 = 1; i2 <= 7; ++i2) {
            Rectangle dayBox = this.getDayBoundsInMonth(month2.getTime(), 0, i2);
            this.paintDayOfMonth(g2, dayBox, cal, CalendarState.DAY_OF_WEEK);
            cal.add(5, 1);
        }
    }

    protected void paintWeekHeader(Graphics g2, Calendar month2) {
        if (!this.monthView.isShowingWeekNumber()) {
            return;
        }
        this.paintWeekOfYearSeparator(g2, month2);
        int weeks = this.getWeeks(month2);
        Calendar weekCalendar = (Calendar)month2.clone();
        for (int week = 1; week < 1 + weeks; ++week) {
            Rectangle dayBox = this.getDayBoundsInMonth(month2.getTime(), week, 0);
            this.paintDayOfMonth(g2, dayBox, weekCalendar, CalendarState.WEEK_OF_YEAR);
            weekCalendar.add(3, 1);
        }
    }

    protected void paintDays(Graphics g2, Calendar month2) {
        Calendar clonedCal = (Calendar)month2.clone();
        CalendarUtils.startOfMonth(clonedCal);
        Date startOfMonth = clonedCal.getTime();
        CalendarUtils.endOfMonth(clonedCal);
        Date endOfMonth = clonedCal.getTime();
        clonedCal.setTime(month2.getTime());
        clonedCal.setTime(month2.getTime());
        CalendarUtils.startOfWeek(clonedCal);
        for (int week = 1; week <= 6; ++week) {
            for (int day = 1; day <= 7; ++day) {
                CalendarState state = null;
                if (clonedCal.getTime().before(startOfMonth)) {
                    if (this.monthView.isShowingLeadingDays()) {
                        state = CalendarState.LEADING;
                    }
                } else if (clonedCal.getTime().after(endOfMonth)) {
                    if (this.monthView.isShowingTrailingDays()) {
                        state = CalendarState.TRAILING;
                    }
                } else {
                    CalendarState calendarState = state = this.isToday(clonedCal.getTime()) ? CalendarState.TODAY : CalendarState.IN_MONTH;
                }
                if (state != null) {
                    Rectangle bounds = this.getDayBoundsInMonth(startOfMonth, week, day);
                    this.paintDayOfMonth(g2, bounds, clonedCal, state);
                }
                clonedCal.add(5, 1);
            }
        }
    }

    protected void paintDayOfMonth(Graphics g2, Rectangle bounds, Calendar calendar, CalendarState state) {
        JComponent comp = this.getRenderingHandler().prepareRenderingComponent(this.monthView, calendar, state);
        this.rendererPane.paintComponent(g2, comp, this.monthView, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    protected void paintWeekOfYearSeparator(Graphics g2, Calendar month2) {
        Rectangle r2 = this.getSeparatorBounds(month2, 1, 0);
        if (r2 == null) {
            return;
        }
        g2.setColor(this.monthView.getForeground());
        g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height);
    }

    protected void paintDaysOfWeekSeparator(Graphics g2, Calendar month2) {
        Rectangle r2 = this.getSeparatorBounds(month2, 0, 1);
        if (r2 == null) {
            return;
        }
        g2.setColor(this.monthView.getForeground());
        g2.drawLine(r2.x, r2.y, r2.x + r2.width, r2.y);
    }

    private Rectangle getSeparatorBounds(Calendar month2, int row, int column2) {
        Rectangle separator = this.getDayBoundsInMonth(month2.getTime(), row, column2);
        if (separator == null) {
            return null;
        }
        if (column2 == 0) {
            separator.height *= 6;
            if (this.isLeftToRight) {
                separator.x += separator.width - 1;
            }
            separator.width = 1;
        } else if (row == 0) {
            int oldWidth = separator.width;
            separator.width *= 7;
            if (!this.isLeftToRight) {
                separator.x -= separator.width - oldWidth;
            }
            separator.y += separator.height - 1;
            separator.height = 1;
        }
        return separator;
    }

    protected int getWeeks(Calendar month2) {
        Calendar cloned = (Calendar)month2.clone();
        CalendarUtils.endOfMonth(cloned);
        Date last = cloned.getTime();
        cloned.setTime(month2.getTime());
        CalendarUtils.startOfWeek(cloned);
        int weeks = 0;
        while (last.after(cloned.getTime())) {
            ++weeks;
            cloned.add(4, 1);
        }
        return weeks;
    }

    private void traverseMonth(int arrowType) {
        if (arrowType == 1) {
            this.previousMonth();
        } else if (arrowType == 2) {
            this.nextMonth();
        }
    }

    private void nextMonth() {
        Date upperBound = this.monthView.getUpperBound();
        if (upperBound == null || upperBound.after(this.getLastDisplayedDay())) {
            Calendar cal = this.getCalendar();
            cal.add(2, 1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    private void previousMonth() {
        Date lowerBound = this.monthView.getLowerBound();
        if (lowerBound == null || lowerBound.before(this.getFirstDisplayedDay())) {
            Calendar cal = this.getCalendar();
            cal.add(2, -1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    protected Calendar getCalendar() {
        return this.getCalendar(this.getFirstDisplayedDay());
    }

    protected Calendar getCalendar(Date date) {
        Calendar calendar = this.monthView.getCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private void updateLastDisplayedDay(Date first2) {
        Calendar cal = this.getCalendar(first2);
        cal.add(2, this.calendarColumnCount * this.calendarRowCount - 1);
        CalendarUtils.endOfMonth(cal);
        this.lastDisplayedDate = cal.getTime();
    }

    @Override
    public Date getLastDisplayedDay() {
        return this.lastDisplayedDate;
    }

    protected void setFirstDisplayedDay(Date firstDisplayedDay) {
        this.updateLastDisplayedDay(firstDisplayedDay);
    }

    protected Date getFirstDisplayedDay() {
        return this.monthView.getFirstDisplayedDay();
    }

    protected int getFirstDisplayedMonth() {
        return this.getCalendar().get(2);
    }

    protected int getFirstDisplayedYear() {
        return this.getCalendar().get(1);
    }

    protected SortedSet<Date> getSelection() {
        return this.monthView.getSelection();
    }

    protected Date getToday() {
        return this.monthView.getToday();
    }

    protected boolean isToday(Date date) {
        return date.equals(this.getToday());
    }

    private boolean canSelectByMode() {
        return true;
    }

    protected void updateZoomable() {
        if (this.monthView.isZoomable()) {
            this.monthView.add(this.getCalendarHeaderHandler().getHeaderComponent());
        } else {
            this.monthView.remove(this.getCalendarHeaderHandler().getHeaderComponent());
        }
        this.monthView.revalidate();
        this.monthView.repaint();
    }

    protected CalendarHeaderHandler createCalendarHeaderHandler() {
        CalendarHeaderHandler handler2 = this.getHeaderFromUIManager();
        return handler2 != null ? handler2 : new BasicCalendarHeaderHandler();
    }

    protected CalendarHeaderHandler getHeaderFromUIManager() {
        Object handlerClass = UIManager.get("CalendarHeaderHandler");
        if (handlerClass instanceof String) {
            return this.instantiateClass((String)handlerClass);
        }
        return null;
    }

    private CalendarHeaderHandler instantiateClass(String handlerClassName) {
        Class<?> handler2 = null;
        try {
            handler2 = Class.forName(handlerClassName);
            return this.instantiateClass(handler2);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private CalendarHeaderHandler instantiateClass(Class<?> handlerClass) {
        Constructor<?> constructor = null;
        try {
            constructor = handlerClass.getConstructor(new Class[0]);
        }
        catch (SecurityException e2) {
            LOG.finer("cant instantiate CalendarHeaderHandler (security) " + handlerClass);
        }
        catch (NoSuchMethodException e3) {
            LOG.finer("cant instantiate CalendarHeaderHandler (missing parameterless constructo?)" + handlerClass);
        }
        if (constructor != null) {
            try {
                return (CalendarHeaderHandler)constructor.newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e4) {
                LOG.finer("cant instantiate CalendarHeaderHandler (missing parameterless constructo?)" + handlerClass);
            }
            catch (InstantiationException e5) {
                LOG.finer("cant instantiate CalendarHeaderHandler (not instantiable) " + handlerClass);
            }
            catch (IllegalAccessException e6) {
                LOG.finer("cant instantiate CalendarHeaderHandler (constructor not public) " + handlerClass);
            }
            catch (InvocationTargetException e7) {
                LOG.finer("cant instantiate CalendarHeaderHandler (Invocation target)" + handlerClass);
            }
        }
        return null;
    }

    protected void setCalendarHeaderHandler(CalendarHeaderHandler calendarHeaderHandler) {
        this.calendarHeaderHandler = calendarHeaderHandler;
    }

    protected CalendarHeaderHandler getCalendarHeaderHandler() {
        return this.calendarHeaderHandler;
    }

    @Deprecated
    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADJUST_SELECTION_PREVIOUS_DAY = 6;
        public static final int ADJUST_SELECTION_NEXT_DAY = 7;
        public static final int ADJUST_SELECTION_PREVIOUS_WEEK = 8;
        public static final int ADJUST_SELECTION_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            if (!BasicMonthViewUI.this.isUsingKeyboard()) {
                BasicMonthViewUI.this.originalDateSpan = BasicMonthViewUI.this.getSelection();
            }
            if (this.action >= 0 && this.action <= 1) {
                if (this.action == 1) {
                    if (BasicMonthViewUI.this.originalDateSpan != null && !BasicMonthViewUI.this.originalDateSpan.isEmpty()) {
                        BasicMonthViewUI.this.monthView.setSelectionInterval((Date)BasicMonthViewUI.this.originalDateSpan.first(), (Date)BasicMonthViewUI.this.originalDateSpan.last());
                    } else {
                        BasicMonthViewUI.this.monthView.clearSelection();
                    }
                    BasicMonthViewUI.this.monthView.cancelSelection();
                } else {
                    BasicMonthViewUI.this.monthView.commitSelection();
                }
                BasicMonthViewUI.this.setUsingKeyboard(false);
            } else if (this.action >= 2 && this.action <= 5) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                BasicMonthViewUI.this.pivotDate = null;
                this.traverse(this.action);
            } else if (this.isIntervalMode() && this.action >= 6 && this.action <= 9) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                this.addToSelection(this.action);
            }
        }

        private boolean isIntervalMode() {
            return BasicMonthViewUI.this.monthView.getSelectionMode() != DateSelectionModel.SelectionMode.SINGLE_SELECTION;
        }

        private void traverse(int action) {
            Date oldStart = BasicMonthViewUI.this.monthView.isSelectionEmpty() ? BasicMonthViewUI.this.monthView.getToday() : BasicMonthViewUI.this.monthView.getFirstSelectionDate();
            Calendar cal = BasicMonthViewUI.this.getCalendar(oldStart);
            switch (action) {
                case 2: {
                    cal.add(5, -1);
                    break;
                }
                case 3: {
                    cal.add(5, 1);
                    break;
                }
                case 4: {
                    cal.add(5, -7);
                    break;
                }
                case 5: {
                    cal.add(5, 7);
                }
            }
            Date newStartDate = cal.getTime();
            if (!newStartDate.equals(oldStart)) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(newStartDate, newStartDate);
                BasicMonthViewUI.this.monthView.ensureDateVisible(newStartDate);
            }
        }

        private void addToSelection(int action) {
            boolean isStartMoved;
            Date newEndDate;
            Date selectionEnd;
            Date newStartDate;
            Date selectionStart;
            if (!BasicMonthViewUI.this.monthView.isSelectionEmpty()) {
                newStartDate = selectionStart = BasicMonthViewUI.this.monthView.getFirstSelectionDate();
                newEndDate = selectionEnd = BasicMonthViewUI.this.monthView.getLastSelectionDate();
            } else {
                newEndDate = selectionEnd = (newStartDate = (selectionStart = BasicMonthViewUI.this.monthView.getToday()));
            }
            if (BasicMonthViewUI.this.pivotDate == null) {
                BasicMonthViewUI.this.pivotDate = newStartDate;
            }
            Calendar cal = BasicMonthViewUI.this.getCalendar();
            switch (action) {
                case 6: {
                    if (newEndDate.after(BasicMonthViewUI.this.pivotDate)) {
                        newEndDate = this.previousDay(cal, newEndDate);
                        isStartMoved = false;
                        break;
                    }
                    newStartDate = this.previousDay(cal, newStartDate);
                    newEndDate = BasicMonthViewUI.this.pivotDate;
                    isStartMoved = true;
                    break;
                }
                case 7: {
                    if (newStartDate.before(BasicMonthViewUI.this.pivotDate)) {
                        newStartDate = this.nextDay(cal, newStartDate);
                        isStartMoved = true;
                        break;
                    }
                    newEndDate = this.nextDay(cal, newEndDate);
                    isStartMoved = false;
                    newStartDate = BasicMonthViewUI.this.pivotDate;
                    break;
                }
                case 8: {
                    if (newEndDate.after(BasicMonthViewUI.this.pivotDate)) {
                        Date newTime = this.previousWeek(cal, newEndDate);
                        if (newTime.after(BasicMonthViewUI.this.pivotDate)) {
                            newEndDate = newTime;
                            isStartMoved = false;
                            break;
                        }
                        newStartDate = newTime;
                        newEndDate = BasicMonthViewUI.this.pivotDate;
                        isStartMoved = true;
                        break;
                    }
                    newStartDate = this.previousWeek(cal, newStartDate);
                    isStartMoved = true;
                    break;
                }
                case 9: {
                    if (newStartDate.before(BasicMonthViewUI.this.pivotDate)) {
                        Date newTime = this.nextWeek(cal, newStartDate);
                        if (newTime.before(BasicMonthViewUI.this.pivotDate)) {
                            newStartDate = newTime;
                            isStartMoved = true;
                            break;
                        }
                        newStartDate = BasicMonthViewUI.this.pivotDate;
                        newEndDate = newTime;
                        isStartMoved = false;
                        break;
                    }
                    newEndDate = this.nextWeek(cal, newEndDate);
                    isStartMoved = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid adjustment action: " + action);
                }
            }
            if (!newStartDate.equals(selectionStart) || !newEndDate.equals(selectionEnd)) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(newStartDate, newEndDate);
                BasicMonthViewUI.this.monthView.ensureDateVisible(isStartMoved ? newStartDate : newEndDate);
            }
        }

        private Date nextWeek(Calendar cal, Date date) {
            cal.setTime(date);
            cal.add(5, 7);
            return cal.getTime();
        }

        private Date previousWeek(Calendar cal, Date date) {
            cal.setTime(date);
            cal.add(5, -7);
            return cal.getTime();
        }

        private Date nextDay(Calendar cal, Date date) {
            cal.setTime(date);
            cal.add(5, 1);
            return cal.getTime();
        }

        private Date previousDay(Calendar cal, Date date) {
            cal.setTime(date);
            cal.add(5, -1);
            return cal.getTime();
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    LayoutManager,
    PropertyChangeListener,
    DateSelectionListener {
        private boolean armed;
        private Date startDate;
        private Date endDate;
        private Dimension preferredSize = new Dimension();

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            int arrowType;
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (BasicMonthViewUI.this.monthView.isTraversable() && (arrowType = BasicMonthViewUI.this.getTraversableGridPositionAtLocation(e2.getX(), e2.getY())) != -1) {
                BasicMonthViewUI.this.traverseMonth(arrowType);
                return;
            }
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            Date cal = BasicMonthViewUI.this.getDayAtLocation(e2.getX(), e2.getY());
            if (cal == null) {
                return;
            }
            this.startDate = cal;
            this.endDate = cal;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION || BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION) {
                BasicMonthViewUI.this.pivotDate = this.startDate;
            }
            BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e2.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(this.startDate, this.endDate);
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(this.startDate, this.endDate);
            }
            this.armed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (this.armed) {
                BasicMonthViewUI.this.monthView.commitSelection();
            }
            this.armed = false;
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled() || !BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            Date cal = BasicMonthViewUI.this.getDayAtLocation(e2.getX(), e2.getY());
            if (cal == null) {
                return;
            }
            Date selected = cal;
            Date oldStart = this.startDate;
            Date oldEnd = this.endDate;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_SELECTION) {
                if (selected.equals(oldStart)) {
                    return;
                }
                this.startDate = selected;
                this.endDate = selected;
            } else if (BasicMonthViewUI.this.pivotDate != null) {
                if (selected.before(BasicMonthViewUI.this.pivotDate)) {
                    this.startDate = selected;
                    this.endDate = BasicMonthViewUI.this.pivotDate;
                } else if (selected.after(BasicMonthViewUI.this.pivotDate)) {
                    this.startDate = BasicMonthViewUI.this.pivotDate;
                    this.endDate = selected;
                }
            } else {
                this.startDate = selected;
                this.endDate = selected;
                BasicMonthViewUI.this.pivotDate = selected;
            }
            if (this.startDate.equals(oldStart) && this.endDate.equals(oldEnd)) {
                return;
            }
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e2.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(this.startDate, this.endDate);
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(this.startDate, this.endDate);
            }
            this.armed = true;
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return new Dimension(this.preferredSize);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension pref;
            JComponent comp;
            int i2;
            int maxMonthWidth = 0;
            int maxMonthHeight = 0;
            Calendar calendar = BasicMonthViewUI.this.getCalendar();
            for (int i3 = calendar.getMinimum(2); i3 <= calendar.getMaximum(2); ++i3) {
                calendar.set(2, i3);
                CalendarUtils.startOfMonth(calendar);
                JComponent comp2 = BasicMonthViewUI.this.getRenderingHandler().prepareRenderingComponent(BasicMonthViewUI.this.monthView, calendar, CalendarState.TITLE);
                Dimension pref2 = comp2.getPreferredSize();
                maxMonthWidth = Math.max(maxMonthWidth, pref2.width);
                maxMonthHeight = Math.max(maxMonthHeight, pref2.height);
            }
            int maxBoxWidth = 0;
            int maxBoxHeight = 0;
            calendar = BasicMonthViewUI.this.getCalendar();
            CalendarUtils.startOfWeek(calendar);
            for (i2 = 0; i2 < 7; ++i2) {
                comp = BasicMonthViewUI.this.getRenderingHandler().prepareRenderingComponent(BasicMonthViewUI.this.monthView, calendar, CalendarState.DAY_OF_WEEK);
                pref = comp.getPreferredSize();
                maxBoxWidth = Math.max(maxBoxWidth, pref.width);
                maxBoxHeight = Math.max(maxBoxHeight, pref.height);
                calendar.add(5, 1);
            }
            calendar = BasicMonthViewUI.this.getCalendar();
            for (i2 = 0; i2 < calendar.getMaximum(5); ++i2) {
                comp = BasicMonthViewUI.this.getRenderingHandler().prepareRenderingComponent(BasicMonthViewUI.this.monthView, calendar, CalendarState.IN_MONTH);
                pref = comp.getPreferredSize();
                maxBoxWidth = Math.max(maxBoxWidth, pref.width);
                maxBoxHeight = Math.max(maxBoxHeight, pref.height);
                calendar.add(5, 1);
            }
            int dayColumns = 7;
            if (BasicMonthViewUI.this.monthView.isShowingWeekNumber()) {
                ++dayColumns;
            }
            if (maxMonthWidth > maxBoxWidth * dayColumns) {
                double diff = maxMonthWidth - maxBoxWidth * dayColumns;
                maxBoxWidth = (int)((double)maxBoxWidth + Math.ceil(diff / (double)dayColumns));
            }
            BasicMonthViewUI.this.fullBoxWidth = maxBoxWidth;
            BasicMonthViewUI.this.fullBoxHeight = maxBoxHeight;
            int boxHeight = maxBoxHeight - 2 * BasicMonthViewUI.this.monthView.getBoxPaddingY();
            BasicMonthViewUI.this.fullMonthBoxHeight = Math.max(boxHeight, maxMonthHeight);
            BasicMonthViewUI.this.calendarWidth = BasicMonthViewUI.this.fullBoxWidth * 7;
            if (BasicMonthViewUI.this.monthView.isShowingWeekNumber()) {
                BasicMonthViewUI.this.calendarWidth += BasicMonthViewUI.this.fullBoxWidth;
            }
            BasicMonthViewUI.this.fullCalendarWidth = BasicMonthViewUI.this.calendarWidth + 10;
            BasicMonthViewUI.this.calendarHeight = BasicMonthViewUI.this.fullBoxHeight * 7 + BasicMonthViewUI.this.fullMonthBoxHeight;
            BasicMonthViewUI.this.fullCalendarHeight = BasicMonthViewUI.this.calendarHeight + 10;
            int prefRows = this.getPreferredRows();
            this.preferredSize.height = BasicMonthViewUI.this.calendarHeight * prefRows + 10 * (prefRows - 1);
            int prefCols = this.getPreferredColumns();
            this.preferredSize.width = BasicMonthViewUI.this.calendarWidth * prefCols + 10 * (prefCols - 1);
            Insets insets = BasicMonthViewUI.this.monthView.getInsets();
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
            BasicMonthViewUI.this.calculateMonthGridLayoutProperties();
            if (BasicMonthViewUI.this.isZoomable()) {
                BasicMonthViewUI.this.getCalendarHeaderHandler().getHeaderComponent().setBounds(BasicMonthViewUI.this.getMonthHeaderBounds(BasicMonthViewUI.this.monthView.getFirstDisplayedDay(), false));
            }
        }

        private int getPreferredColumns() {
            return BasicMonthViewUI.this.isZoomable() ? 1 : BasicMonthViewUI.this.monthView.getPreferredColumnCount();
        }

        private int getPreferredRows() {
            return BasicMonthViewUI.this.isZoomable() ? 1 : BasicMonthViewUI.this.monthView.getPreferredRowCount();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("componentOrientation".equals(property)) {
                BasicMonthViewUI.this.isLeftToRight = BasicMonthViewUI.this.monthView.getComponentOrientation().isLeftToRight();
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("selectionModel".equals(property)) {
                DateSelectionModel selectionModel = (DateSelectionModel)evt.getOldValue();
                selectionModel.removeDateSelectionListener(BasicMonthViewUI.this.getHandler());
                selectionModel = (DateSelectionModel)evt.getNewValue();
                selectionModel.addDateSelectionListener(BasicMonthViewUI.this.getHandler());
            } else if ("firstDisplayedDay".equals(property)) {
                BasicMonthViewUI.this.setFirstDisplayedDay((Date)evt.getNewValue());
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("boxPaddingX".equals(property) || "boxPaddingY".equals(property) || "traversable".equals(property) || "daysOfTheWeek".equals(property) || "border".equals(property) || "showingWeekNumber".equals(property) || "traversable".equals(property)) {
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("zoomable".equals(property)) {
                BasicMonthViewUI.this.updateZoomable();
            } else if ("componentInputMapEnabled".equals(property)) {
                BasicMonthViewUI.this.updateComponentInputMap();
            } else if ("locale".equals(property)) {
                BasicMonthViewUI.this.updateLocale(true);
            } else {
                BasicMonthViewUI.this.monthView.repaint();
            }
        }

        @Override
        public void valueChanged(DateSelectionEvent ev) {
            BasicMonthViewUI.this.monthView.repaint();
        }
    }

    protected static class RenderingHandler
    extends BasicCalendarRenderingHandler {
        protected RenderingHandler() {
        }
    }
}

