/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.List;
import java.util.Random;
import org.jetbrains.jetCheck.BoundedIntDistribution;

public interface IntDistribution {
    public int generateInt(Random var1);

    public boolean isValidValue(int var1);

    public int getMin();

    public int getMax();

    public static IntDistribution uniform(int min, int max) {
        return new BoundedIntDistribution(min, max, r2 -> {
            int i2;
            if (min == max) {
                return min;
            }
            int range = max - min + 1;
            if (range > 0) {
                return r2.nextInt(range) + min;
            }
            while ((i2 = r2.nextInt()) < min || i2 > max) {
            }
            return i2;
        });
    }

    public static IntDistribution geometric(int mean) {
        double p2 = 1.0 / (double)(mean + 1);
        return new BoundedIntDistribution(0, Integer.MAX_VALUE, random -> {
            double u2 = random.nextDouble();
            return (int)(Math.log(u2) / Math.log(1.0 - p2));
        });
    }

    public static IntDistribution frequencyDistribution(List<Integer> weights) {
        if (weights.isEmpty()) {
            throw new IllegalArgumentException("No alternatives to choose from");
        }
        int sum2 = weights.stream().reduce(0, (a2, b2) -> a2 + b2);
        return new BoundedIntDistribution(0, weights.size() - 1, r2 -> {
            int value = r2.nextInt(sum2);
            for (int i2 = 0; i2 < weights.size(); ++i2) {
                if ((value -= ((Integer)weights.get(i2)).intValue()) >= 0) continue;
                return i2;
            }
            throw new IllegalArgumentException();
        });
    }
}

