/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment;

import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deployment.DockerRunConfigurationPathHandler;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a#\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "configurations", "Lcom/intellij/util/containers/MultiMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/docker/deployment/DockerRunConfigurationManager$Record;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "handleRename", "oldPath", "newPath", "refresh", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "unregisterRunConfig", "registerRunConfig", "registerPath", "pathHandler", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "pointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Record", "Companion", "RunManagerListenerImpl", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerRunConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationManager.kt\ncom/intellij/docker/deployment/DockerRunConfigurationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,150:1\n1869#2,2:151\n774#2:155\n865#2,2:156\n1869#2,2:158\n13805#3,2:153\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationManager.kt\ncom/intellij/docker/deployment/DockerRunConfigurationManager\n*L\n47#1:151,2\n69#1:155\n69#1:156,2\n69#1:158,2\n63#1:153,2\n*E\n"})
public final class DockerRunConfigurationManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MultiMap<String, Record> configurations;

    public DockerRunConfigurationManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        MultiMap multiMap = MultiMap.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrentSet(...)");
        this.configurations = multiMap;
        DockerRunConfigurationPathHandler.Companion.getEP_NAME().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DockerRunConfigurationPathHandler>(){

            /*
             * WARNING - void declaration
             */
            public void extensionAdded(DockerRunConfigurationPathHandler extension, PluginDescriptor pluginDescriptor) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                configurations.clear();
                Iterable iterable = InternalUtilsKt.getDockerRunConfigs(project);
                DockerRunConfigurationManager dockerRunConfigurationManager = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DockerRunConfig.Wrapper it = (DockerRunConfig.Wrapper)element$iv;
                    boolean bl = false;
                    dockerRunConfigurationManager.registerRunConfig(it.getDockerRunConfig());
                }
            }

            public void extensionRemoved(DockerRunConfigurationPathHandler extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                Iterator iterator2 = configurations.values().iterator();
                while (iterator2.hasNext()) {
                    Record nextRecord = (Record)iterator2.next();
                    if (!Intrinsics.areEqual((Object)nextRecord.getPathHandler(), (Object)extension)) continue;
                    iterator2.remove();
                }
            }
        }, (Disposable)this);
    }

    public void dispose() {
        this.configurations.clear();
    }

    private final void handleRename(String oldPath, String newPath) {
        block1: {
            Collection collection = this.configurations.remove((Object)oldPath);
            if (collection == null) break block1;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Record it = (Record)element$iv;
                boolean bl = false;
                it.getPathHandler().replacePath(this.project, it.getRunConfig(), oldPath, newPath);
                this.registerPath(it.getRunConfig(), it.getPathHandler(), it.getPointer());
            }
        }
    }

    private final void refresh(DockerRunConfig dockerRunConfig) {
        this.unregisterRunConfig(dockerRunConfig);
        this.registerRunConfig(dockerRunConfig);
    }

    private final void unregisterRunConfig(DockerRunConfig dockerRunConfig) {
        this.configurations.values().removeIf(arg_0 -> DockerRunConfigurationManager.unregisterRunConfig$lambda$1(arg_0 -> DockerRunConfigurationManager.unregisterRunConfig$lambda$0(dockerRunConfig, arg_0), arg_0));
    }

    private final void registerRunConfig(DockerRunConfig dockerRunConfig) {
        Object[] $this$forEach$iv = DockerRunConfigurationPathHandler.Companion.getEP_NAME().getExtensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerRunConfigurationPathHandler it = (DockerRunConfigurationPathHandler)element$iv;
            boolean bl = false;
            this.registerPath(dockerRunConfig, it, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerPath(DockerRunConfig dockerRunConfig, DockerRunConfigurationPathHandler pathHandler, VirtualFilePointer pointer) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = pathHandler.getPaths(this.project, dockerRunConfig);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path2 = (String)element$iv;
            boolean bl = false;
            Ref oldName = new Ref();
            VirtualFilePointer virtualFilePointer = pointer;
            if (virtualFilePointer == null) {
                virtualFilePointer = InternalUtilsKt.toVirtualFilePointer(path2, false, this, (Function1<? super VirtualFilePointer, Unit>)((Function1)arg_0 -> DockerRunConfigurationManager.registerPath$lambda$1$0(oldName, arg_0)), (Function1<? super VirtualFilePointer, Unit>)((Function1)arg_0 -> DockerRunConfigurationManager.registerPath$lambda$1$1(oldName, this, arg_0)));
            }
            VirtualFilePointer filePointer = virtualFilePointer;
            this.configurations.putValue((Object)path2, (Object)new Record(dockerRunConfig, pathHandler, filePointer));
        }
    }

    private static final boolean unregisterRunConfig$lambda$0(DockerRunConfig $dockerRunConfig, Record it) {
        return Intrinsics.areEqual((Object)it.getRunConfig().getDeployment(), (Object)$dockerRunConfig.getDeployment());
    }

    private static final boolean unregisterRunConfig$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit registerPath$lambda$1$0(Ref $oldName, VirtualFilePointer it) {
        VirtualFilePointer virtualFilePointer = it;
        $oldName.set(virtualFilePointer != null && (virtualFilePointer = virtualFilePointer.getFile()) != null ? virtualFilePointer.getPath() : null);
        return Unit.INSTANCE;
    }

    private static final Unit registerPath$lambda$1$1(Ref $oldName, DockerRunConfigurationManager this$0, VirtualFilePointer it) {
        String string;
        String old = (String)$oldName.get();
        VirtualFilePointer virtualFilePointer = it;
        String string2 = virtualFilePointer != null && (virtualFilePointer = virtualFilePointer.getFile()) != null ? virtualFilePointer.getPath() : (string = null);
        if (old != null && string != null) {
            this$0.handleRename(old, string);
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final DockerRunConfigurationManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/deployment/DockerRunConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerRunConfigurationManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DockerRunConfigurationManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DockerRunConfigurationManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationManager$Record;", "", "runConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "pathHandler", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "pointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "<init>", "(Lcom/intellij/docker/deployment/DockerRunConfig;Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;)V", "getRunConfig", "()Lcom/intellij/docker/deployment/DockerRunConfig;", "getPathHandler", "()Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "getPointer", "()Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "copy", "toString", "", "intellij.clouds.docker"})
    private static final class Record {
        @NotNull
        private final DockerRunConfig runConfig;
        @NotNull
        private final DockerRunConfigurationPathHandler pathHandler;
        @Nullable
        private final VirtualFilePointer pointer;

        public Record(@NotNull DockerRunConfig runConfig, @NotNull DockerRunConfigurationPathHandler pathHandler, @Nullable VirtualFilePointer pointer) {
            Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
            Intrinsics.checkNotNullParameter((Object)pathHandler, (String)"pathHandler");
            this.runConfig = runConfig;
            this.pathHandler = pathHandler;
            this.pointer = pointer;
        }

        @NotNull
        public final DockerRunConfig getRunConfig() {
            return this.runConfig;
        }

        @NotNull
        public final DockerRunConfigurationPathHandler getPathHandler() {
            return this.pathHandler;
        }

        @Nullable
        public final VirtualFilePointer getPointer() {
            return this.pointer;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            if (!(other instanceof Record)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.runConfig.getDeployment(), (Object)((Record)other).runConfig.getDeployment())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pathHandler, (Object)((Record)other).pathHandler)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pointer, (Object)((Record)other).pointer);
        }

        public int hashCode() {
            int result2 = this.runConfig.getDeployment().hashCode();
            result2 = 31 * result2 + this.pathHandler.hashCode();
            VirtualFilePointer virtualFilePointer = this.pointer;
            result2 = 31 * result2 + (virtualFilePointer != null ? virtualFilePointer.hashCode() : 0);
            return result2;
        }

        @NotNull
        public final DockerRunConfig component1() {
            return this.runConfig;
        }

        @NotNull
        public final DockerRunConfigurationPathHandler component2() {
            return this.pathHandler;
        }

        @Nullable
        public final VirtualFilePointer component3() {
            return this.pointer;
        }

        @NotNull
        public final Record copy(@NotNull DockerRunConfig runConfig, @NotNull DockerRunConfigurationPathHandler pathHandler, @Nullable VirtualFilePointer pointer) {
            Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
            Intrinsics.checkNotNullParameter((Object)pathHandler, (String)"pathHandler");
            return new Record(runConfig, pathHandler, pointer);
        }

        public static /* synthetic */ Record copy$default(Record record, DockerRunConfig dockerRunConfig, DockerRunConfigurationPathHandler dockerRunConfigurationPathHandler, VirtualFilePointer virtualFilePointer, int n, Object object) {
            if ((n & 1) != 0) {
                dockerRunConfig = record.runConfig;
            }
            if ((n & 2) != 0) {
                dockerRunConfigurationPathHandler = record.pathHandler;
            }
            if ((n & 4) != 0) {
                virtualFilePointer = record.pointer;
            }
            return record.copy(dockerRunConfig, dockerRunConfigurationPathHandler, virtualFilePointer);
        }

        @NotNull
        public String toString() {
            return "Record(runConfig=" + this.runConfig + ", pathHandler=" + this.pathHandler + ", pointer=" + this.pointer + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationManager$RunManagerListenerImpl;", "Lcom/intellij/execution/RunManagerListener;", "<init>", "()V", "runConfigurationChanged", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationAdded", "runConfigurationRemoved", "getManager", "Lcom/intellij/docker/deployment/DockerRunConfigurationManager;", "intellij.clouds.docker"})
    public static final class RunManagerListenerImpl
    implements RunManagerListener {
        public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                DockerRunConfig.Wrapper wrapper = DockerRunConfig.Wrapper.Companion.asDockerRunConfig(settings);
                if (wrapper == null) break block0;
                DockerRunConfig.Wrapper it = wrapper;
                boolean bl = false;
                this.getManager(settings).refresh(it.getDockerRunConfig());
            }
        }

        public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Project project = settings.getConfiguration().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BuildersKt.launch$default((CoroutineScope)Companion.getInstance(project).scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(settings, this, null){
                int label;
                final /* synthetic */ RunnerAndConfigurationSettings $settings;
                final /* synthetic */ RunManagerListenerImpl this$0;
                {
                    this.$settings = $settings;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            DockerRunConfig.Wrapper wrapper = DockerRunConfig.Wrapper.Companion.asDockerRunConfig(this.$settings);
                            if (wrapper != null) {
                                DockerRunConfig.Wrapper wrapper2 = wrapper;
                                RunManagerListenerImpl runManagerListenerImpl = this.this$0;
                                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.$settings;
                                DockerRunConfig.Wrapper it = wrapper2;
                                boolean bl = false;
                                DockerRunConfigurationManager.access$registerRunConfig(RunManagerListenerImpl.access$getManager(runManagerListenerImpl, runnerAndConfigurationSettings), it.getDockerRunConfig());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                DockerRunConfig.Wrapper wrapper = DockerRunConfig.Wrapper.Companion.asDockerRunConfig(settings);
                if (wrapper == null) break block0;
                DockerRunConfig.Wrapper it = wrapper;
                boolean bl = false;
                this.getManager(settings).unregisterRunConfig(it.getDockerRunConfig());
            }
        }

        private final DockerRunConfigurationManager getManager(RunnerAndConfigurationSettings settings) {
            Project project = settings.getConfiguration().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return Companion.getInstance(project);
        }

        public static final /* synthetic */ DockerRunConfigurationManager access$getManager(RunManagerListenerImpl $this, RunnerAndConfigurationSettings settings) {
            return $this.getManager(settings);
        }
    }
}

