/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaTextPatchBuilder {
    private static final Logger LOG = Logger.getInstance(IdeaTextPatchBuilder.class);

    private IdeaTextPatchBuilder() {
    }

    private static List<BeforeAfter<AirContentRevision>> revisionsConvertor(@NotNull Project project, @NotNull List<? extends Change> changes, boolean honorExcludedFromCommit) {
        if (project == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<BeforeAfter<AirContentRevision>> result2 = new ArrayList<BeforeAfter<AirContentRevision>>(changes.size());
        IdeaTextPatchBuilder.addConvertChanges(project, changes, result2, honorExcludedFromCommit);
        return result2;
    }

    private static void addConvertChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull List<? super BeforeAfter<AirContentRevision>> result2, boolean honorExcludedFromCommit) {
        if (project == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(4);
        }
        List<Change> otherChanges = PartialChangesUtil.processPartialChanges(project, changes, false, (PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean>)((PairFunction)(partialChanges, tracker) -> {
            if (!tracker.hasPartialChangesToCommit()) {
                return false;
            }
            if (!tracker.isOperational()) {
                LOG.warn("Skipping non-operational tracker: " + String.valueOf(tracker));
                return false;
            }
            List changelistIds = ContainerUtil.map((Collection)partialChanges, ChangeListChange::getChangeListId);
            Change change = ((ChangeListChange)partialChanges.get(0)).getChange();
            PartialCommitHelper helper = tracker.handlePartialCommit(Side.LEFT, changelistIds, honorExcludedFromCommit);
            String actualText = helper.getContent();
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), actualText)));
            return true;
        }));
        for (Change change : otherChanges) {
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), null)));
        }
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, @NotNull Collection<? extends Change> changes, @NotNull String basePath, boolean reversePatch) throws VcsException {
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(5);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(6);
        }
        return IdeaTextPatchBuilder.buildPatch(project, changes, Paths.get(basePath, new String[0]), reversePatch, false);
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, @NotNull Collection<? extends Change> changes, @NotNull Path basePath, boolean reversePatch) throws VcsException {
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(7);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(8);
        }
        return IdeaTextPatchBuilder.buildPatch(project, changes, basePath, reversePatch, false);
    }

    @NotNull
    public static List<FilePatch> buildPatch(@Nullable Project project, @NotNull Collection<? extends Change> changes, @NotNull Path basePath, boolean reversePatch, boolean honorExcludedFromCommit) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> revisions;
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(9);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(10);
        }
        if (project != null) {
            revisions = IdeaTextPatchBuilder.revisionsConvertor(project, new ArrayList<Change>(changes), honorExcludedFromCommit);
        } else {
            revisions = new ArrayList(changes.size());
            for (Change change : changes) {
                revisions.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision())));
            }
        }
        List<FilePatch> list = TextPatchBuilder.buildPatch(revisions, basePath, reversePatch);
        if (list == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public static List<FilePatch> buildPatch(@Nullable Project project, @NotNull Collection<? extends Change> changes, @NotNull Path basePath, boolean reversePatch, boolean honorExcludedFromCommit, @Nullable Runnable ignoredParameter) throws VcsException {
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(12);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(13);
        }
        return IdeaTextPatchBuilder.buildPatch(project, changes, basePath, reversePatch, honorExcludedFromCommit);
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr) {
        return IdeaTextPatchBuilder.convertRevision(cr, null);
    }

    public static boolean isBinaryRevision(@Nullable ContentRevision cr) {
        if (cr == null) {
            return false;
        }
        if (cr instanceof BinaryContentRevision) {
            return true;
        }
        FilePath file = cr.getFile();
        FileType type = file.getFileType();
        if (type instanceof UnknownFileType && cr instanceof ByteBackedContentRevision) {
            ByteBackedContentRevision byteBasedContentRevision = (ByteBackedContentRevision)cr;
            try {
                byte[] bytes = byteBasedContentRevision.getContentAsBytes();
                if (bytes != null) {
                    return DiffContentFactoryImpl.isBinaryContent((byte[])bytes, (FileType)type);
                }
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
        return type.isBinary();
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr, @Nullable String actualTextContent) {
        if (cr == null) {
            return null;
        }
        FilePath filePath = cr.getFile();
        if (actualTextContent != null) {
            return new PartialTextAirContentRevision(actualTextContent, cr, filePath);
        }
        if (cr instanceof ByteBackedContentRevision && IdeaTextPatchBuilder.isBinaryRevision(cr)) {
            return new BinaryAirContentRevision((ByteBackedContentRevision)cr, filePath);
        }
        return new TextAirContentRevision(cr, filePath);
    }

    @Nullable
    private static Long getRevisionTimestamp(@NotNull ContentRevision revision) {
        if (revision == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(14);
        }
        if (revision instanceof CurrentContentRevision) {
            try {
                FilePath filePath = revision.getFile();
                Path path = filePath.getIOFile().toPath();
                return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "revisionsConvertor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addConvertChanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildPatch";
                break;
            }
            case 11: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionTimestamp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    private static class PartialTextAirContentRevision
    extends TextAirContentRevision {
        @NotNull
        private final String myContent;

        PartialTextAirContentRevision(@NotNull String content, @NotNull ContentRevision delegateRevision, @NotNull FilePath filePath) {
            if (content == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(0);
            }
            if (delegateRevision == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(2);
            }
            super(delegateRevision, filePath);
            this.myContent = content;
        }

        @Override
        @NotNull
        public String getContentAsString() {
            String string = this.myContent;
            if (string == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public byte[] getContentAsBytes() {
            return this.myContent.getBytes(this.getCharset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateRevision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$PartialTextAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$PartialTextAirContentRevision";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentAsString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class BinaryAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final ByteBackedContentRevision myRevision;
        @NotNull
        private final FilePath myFilePath;

        BinaryAirContentRevision(@NotNull ByteBackedContentRevision revision, @NotNull FilePath filePath) {
            if (revision == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(1);
            }
            this.myRevision = revision;
            this.myFilePath = filePath;
        }

        public boolean isBinary() {
            return true;
        }

        @NotNull
        public String getContentAsString() {
            throw new IllegalStateException();
        }

        public byte[] getContentAsBytes() throws VcsException {
            return this.myRevision.getContentAsBytes();
        }

        public String getRevisionNumber() {
            return this.myRevision.getRevisionNumber().asString();
        }

        @Nullable
        public Long getLastModifiedTimestamp() {
            return IdeaTextPatchBuilder.getRevisionTimestamp((ContentRevision)this.myRevision);
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class TextAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final ContentRevision myRevision;
        @NotNull
        private final FilePath myFilePath;

        TextAirContentRevision(@NotNull ContentRevision revision, @NotNull FilePath filePath) {
            if (revision == null) {
                TextAirContentRevision.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                TextAirContentRevision.$$$reportNull$$$0(1);
            }
            this.myRevision = revision;
            this.myFilePath = filePath;
        }

        public boolean isBinary() {
            return false;
        }

        @NotNull
        public String getContentAsString() throws VcsException {
            String content = this.myRevision.getContent();
            if (content == null) {
                VcsRevisionNumber revisionNumber = this.myRevision.getRevisionNumber();
                String revisionText = revisionNumber != VcsRevisionNumber.NULL ? revisionNumber.asString() : this.myRevision.toString();
                throw new VcsException(VcsBundle.message((String)"patch.failed.to.fetch.old.content.for.file.name.in.revision", (Object[])new Object[]{this.myFilePath.getPath(), revisionText}));
            }
            String string = content;
            if (string == null) {
                TextAirContentRevision.$$$reportNull$$$0(2);
            }
            return string;
        }

        public byte[] getContentAsBytes() throws VcsException {
            return ChangesUtil.loadContentRevision((ContentRevision)this.myRevision);
        }

        public String getRevisionNumber() {
            return this.myRevision.getRevisionNumber().asString();
        }

        @Nullable
        public Long getLastModifiedTimestamp() {
            return IdeaTextPatchBuilder.getRevisionTimestamp(this.myRevision);
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                TextAirContentRevision.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        @NotNull
        public Charset getCharset() {
            Charset charset = this.myRevision.getFile().getCharset();
            if (charset == null) {
                TextAirContentRevision.$$$reportNull$$$0(4);
            }
            return charset;
        }

        @Nullable
        public String getLineSeparator() {
            VirtualFile virtualFile = this.myRevision.getFile().getVirtualFile();
            return virtualFile != null ? virtualFile.getDetectedLineSeparator() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentAsString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

